/*
 * Decompiled with CFR 0.152.
 */
package planung;

import auftraege.Dokumentenklasse;
import auftraege.ProduktionsAuftrag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import maschine.Maschine;
import maschine.MaschinenTyp;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.Units;
import util.CollectionHelper;
import util.Fraction;
import zeit.eintraege.Zeitraum;

public final class Schicht {
    private final Zeitraum zeitraum;
    private final Map<Maschine, Collection<ProduktionsAuftrag>> maschinenProduktionsauftraegeMap;

    private Schicht(Zeitraum zeitraum, Map<Maschine, Collection<ProduktionsAuftrag>> maschinenProduktionsauftraegeMap) {
        this.zeitraum = zeitraum;
        this.maschinenProduktionsauftraegeMap = maschinenProduktionsauftraegeMap;
    }

    public static Schicht createOhneMaschinen(Zeitraum zeitraum) {
        return new Schicht(zeitraum, new HashMap<Maschine, Collection<ProduktionsAuftrag>>());
    }

    public Map<MaschinenTyp, Integer> getMaschinentypen() {
        HashMap<MaschinenTyp, Integer> ret = new HashMap<MaschinenTyp, Integer>();
        this.maschinenProduktionsauftraegeMap.keySet().stream().map(Maschine::getMaschinentyp).forEach(maschinenTyp -> ret.put((MaschinenTyp)maschinenTyp, Optional.ofNullable(ret.get(maschinenTyp)).orElse(0) + 1));
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schicht)) {
            return false;
        }
        Schicht schicht = (Schicht)o;
        if (!this.zeitraum.equals(schicht.zeitraum)) {
            return false;
        }
        return this.maschinenProduktionsauftraegeMap.equals(schicht.maschinenProduktionsauftraegeMap);
    }

    public int hashCode() {
        int result = this.zeitraum.hashCode();
        result = 31 * result + this.maschinenProduktionsauftraegeMap.hashCode();
        return result;
    }

    public Zeitraum getZeitraum() {
        return this.zeitraum;
    }

    public boolean addProduktionsauftrag(ProduktionsAuftrag produktionsAuftrag, Maschine maschine, Fraction produktionssatz) {
        this.maschinenProduktionsauftraegeMap.putIfAbsent(maschine, new ArrayList());
        ComparableQuantity<Time> betriebsdauer = this.berechneBetriebsdauerDerMaschine(maschine, produktionssatz);
        ComparableQuantity produktionsauftragsdauer = maschine.berechneBenoetigteZeit(produktionsAuftrag).multiply((Number)produktionssatz.inversion());
        if (betriebsdauer.add((Quantity)produktionsauftragsdauer).compareTo(this.getSchichtDauer()) > 0) {
            return false;
        }
        this.maschinenProduktionsauftraegeMap.get(maschine).add(produktionsAuftrag);
        return true;
    }

    public Collection<Dokumentenklasse> getDokumentenklassen(Maschine maschine) {
        Collection<ProduktionsAuftrag> produktionsauftraege = this.getMaschinenProduktionsauftraegeMap().get(maschine);
        return produktionsauftraege == null ? new ArrayList<Dokumentenklasse>() : (Collection)produktionsauftraege.stream().map(ProduktionsAuftrag::getDokumentenklassen).reduce(new ArrayList(), CollectionHelper::concat);
    }

    public ComparableQuantity<Time> berechneBetriebsdauerDerMaschine(Maschine maschine, Fraction produktionssatz) {
        this.maschinenProduktionsauftraegeMap.computeIfAbsent(maschine, k -> new HashSet());
        return this.maschinenProduktionsauftraegeMap.get(maschine).stream().map(maschine::berechneBenoetigteZeit).reduce(Quantities.getQuantity((Number)0, (Unit)Units.MINUTE), ComparableQuantity::add).multiply((Number)produktionssatz.inversion());
    }

    public ComparableQuantity<Time> getSchichtDauer() {
        return this.zeitraum.getDauer();
    }

    public Set<ProduktionsAuftrag> getProduktionsauftraege() {
        return this.maschinenProduktionsauftraegeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Map<Maschine, Collection<ProduktionsAuftrag>> getMaschinenProduktionsauftraegeMap() {
        return Collections.unmodifiableMap(this.maschinenProduktionsauftraegeMap);
    }

    public String toString() {
        return "Schicht{zeitraum=" + this.zeitraum + ", auftraege=" + this.maschinenProduktionsauftraegeMap + '}';
    }

    public Schicht copy() {
        return new Schicht(this.zeitraum, new HashMap<Maschine, Collection<ProduktionsAuftrag>>(this.maschinenProduktionsauftraegeMap));
    }
}

