/*
 * Decompiled with CFR 0.152.
 */
package rollenbelegung;

import auftraege.ProduktionsAuftrag;
import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import maschine.Maschine;
import mensch.Mitarbeiter;
import rollenbelegung.MaschinenBelegung;
import rollenbelegung.MitarbeiterBelegung;
import zeit.eintraege.BelegungsEintrag;

public class ErmittelteBelegungen {
    private final Collection<ProduktionsAuftrag> nichtZugeordneteProduktionsauftraege;
    private final Map<Maschine, MaschinenBelegung> maschinenbelegungen;
    private final Map<Mitarbeiter, MitarbeiterBelegung> mitarbeiterbelegungen;

    public ErmittelteBelegungen(Collection<ProduktionsAuftrag> nichtZugeordneteProduktionsauftraege, Map<Maschine, MaschinenBelegung> maschinenbelegungen, Map<Mitarbeiter, MitarbeiterBelegung> mitarbeiterbelegungen) {
        this.nichtZugeordneteProduktionsauftraege = nichtZugeordneteProduktionsauftraege;
        this.maschinenbelegungen = maschinenbelegungen;
        this.mitarbeiterbelegungen = mitarbeiterbelegungen;
    }

    public Collection<ProduktionsAuftrag> getNichtZugeordneteProduktionsauftraege() {
        return Collections.unmodifiableCollection(this.nichtZugeordneteProduktionsauftraege);
    }

    public Map<Maschine, MaschinenBelegung> getMaschinenbelegungen() {
        return Collections.unmodifiableMap(this.maschinenbelegungen);
    }

    public Map<Mitarbeiter, MitarbeiterBelegung> getMitarbeiterbelegungen() {
        return Collections.unmodifiableMap(this.mitarbeiterbelegungen);
    }

    public void erzeugeKalendereintraege() {
        this.maschinenbelegungen.forEach((maschine, maschinenBelegung) -> maschinenBelegung.getBelegung().forEach(maschinenBelegungsEintrag -> {
            maschine.addBelegungsEintrag((BelegungsEintrag)maschinenBelegungsEintrag);
            maschinenBelegungsEintrag.getZuVerarbeitenderAuftrag().addMaschinenBelegungsEintrag(maschine, maschinenBelegungsEintrag);
        }));
        this.mitarbeiterbelegungen.forEach((mitarbeiter, mitarbeiterBelegung) -> mitarbeiterBelegung.getBelegung().forEach(menschBelegungsEintrag -> {
            mitarbeiter.addBelegungsEintrag((BelegungsEintrag)menschBelegungsEintrag);
            menschBelegungsEintrag.getZuVerarbeitenderAuftrag().addMenschBelegungsEintrag(mitarbeiter, menschBelegungsEintrag.getMaschineDieBedientWird().getFaehigkeit(), menschBelegungsEintrag);
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErmittelteBelegungen)) {
            return false;
        }
        ErmittelteBelegungen that = (ErmittelteBelegungen)o;
        return Objects.equal(this.nichtZugeordneteProduktionsauftraege, that.nichtZugeordneteProduktionsauftraege) && Objects.equal(this.maschinenbelegungen, that.maschinenbelegungen) && Objects.equal(this.mitarbeiterbelegungen, that.mitarbeiterbelegungen);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nichtZugeordneteProduktionsauftraege, this.maschinenbelegungen, this.mitarbeiterbelegungen});
    }
}

