package de.fhdw.gaming.ipspiel21.iterationalContest;

import de.fhdw.gaming.core.domain.GameBuilderFactory;

/**
 * Encapsulates the parameters of a competition. A competition consists of at least one contest. Two contests of the
 * same competition differ in the players (and, hence, the strategies) involved. In our case, running a competition will
 * let players of each available strategy combination play against each other.
 */
final class CompetitionParameters {

    /**
     * {@link GameBuilderFactory} to use.
     */
    private final GameBuilderFactory gameBuilderFactory;
    /**
     * The number of games to be played per contest.
     */
    private final int numberOfGamesPerContest;
    /**
     * The maximum computation time in seconds per player and move.
     */
    private final int maxComputationTimePerMove;

    /**
     * Creates a {@link CompetitionParameters} object.
     *
     * @param gameBuilderFactory        The {@link GameBuilderFactory} to use.
     * @param numberOfGamesPerContest   The number of games per contest to be played.
     * @param maxComputationTimePerMove The maximum computation time in seconds per player and move.
     */
    CompetitionParameters(final GameBuilderFactory gameBuilderFactory, final int numberOfGamesPerContest,
            final int maxComputationTimePerMove) {
        this.gameBuilderFactory = gameBuilderFactory;
        this.numberOfGamesPerContest = numberOfGamesPerContest;
        this.maxComputationTimePerMove = maxComputationTimePerMove;

    }

    /**
     * Returns the {@link GameBuilderFactory} to use.
     */
    GameBuilderFactory getGameBuilderFactory() {
        return this.gameBuilderFactory;
    }

    /**
     * Returns the number of games per contest to be played .
     */
    int getNumberOfGamesPerContest() {
        return this.numberOfGamesPerContest;
    }

    /**
     * Returns the maximum computation time in seconds per player and move.
     */
    public int getMaxComputationTimePerMove() {
        return this.maxComputationTimePerMove;
    }

}