/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-kopfzahlkante.
 *
 * Ipspiel21-kopfzahlkante is free software: you can redistribute it and/or modify it under 
 * the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, 
 * or (at your option) any later
 * version.
 *
 * Ipspiel21-kopfzahlkante is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-kopfzahlkante. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Implements {@link KopfzahlkanteStrategyFactoryProvider} by using the
 * {@link ServiceLoader}.
 */
public final class KopfzahlkanteDefaultStrategyFactoryProvider implements KopfzahlkanteStrategyFactoryProvider {

    @Override
    public List<KopfzahlkanteStrategyFactory> getStrategyFactories() {
        final ServiceLoader<KopfzahlkanteStrategyFactory> services = ServiceLoader
                .load(KopfzahlkanteStrategyFactory.class);
        final List<KopfzahlkanteStrategyFactory> list = new ArrayList<>();
        services.iterator().forEachRemaining(list::add);
        return list;
    }
}
