package de.fhdw.gaming.ipspiel21.customGui.gui;

import java.util.Map;
import java.util.Optional;
import java.util.Set;

import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;

/**
 * A customized {@link InputProvider} for Configure a Strategy by user.
 *
 */
public final class CustomInputProvider implements InputProvider {


    /**
     * The {@link InputProvider} to be decorated(customized).
     */
    private final InputProvider actualInputProvider;

    /**
     * Creates a {@link CustomInputProvider}.
     *
     * @param inputProvider
     */
    public CustomInputProvider(final InputProvider inputProvider) {
        this.actualInputProvider = inputProvider;
    }

    @SuppressWarnings("unchecked")
    @Override
    public InputProvider needString(final String id, final String prompt, final Optional<String> defaultValue,
            final Validator<String>... validators) throws InputProviderException {
        return this.actualInputProvider.needString(id, prompt, defaultValue, validators);

    }

    @Override
    public InputProvider fixedString(final String id, final String fixedValue) throws InputProviderException {
        return this.actualInputProvider.fixedString(id, fixedValue);
    }

    @SuppressWarnings("unchecked")
    @Override
    public InputProvider needInteger(final String id, final String prompt, final Optional<Integer> defaultValue,
            final Validator<Integer>... validators) throws InputProviderException {
        return this.actualInputProvider.needInteger(id, prompt, defaultValue, validators);
    }

    @Override
    public InputProvider fixedInteger(final String id, final Integer fixedValue) throws InputProviderException {
        return this.actualInputProvider.fixedInteger(id, fixedValue);
    }

    @SuppressWarnings("unchecked")
    @Override
    public InputProvider needBoolean(final String id, final String prompt, final Optional<Boolean> defaultValue,
            final Validator<Boolean>... validators) throws InputProviderException {
        return this.actualInputProvider.needBoolean(id, prompt, defaultValue, validators);
    }

    @Override
    public InputProvider fixedBoolean(final String id, final Boolean fixedValue) throws InputProviderException {
        return this.actualInputProvider.fixedBoolean(id, fixedValue);
    }

    @Override
    public InputProvider needObject(final String id, final String prompt, final Optional<Object> defaultValue,
            final Set<? extends Object> objectSet) throws InputProviderException {
        this.actualInputProvider.needObject(id, prompt, defaultValue, objectSet);
        return this;
    }

    @Override
    public InputProvider fixedObject(final String id, final Object fixedValue) throws InputProviderException {
        return this.actualInputProvider.fixedObject(id, fixedValue);
    }

    @Override
    public Map<String, Object> requestData(final String title) throws InputProviderException {
        final Dialog<ButtonType> dialog = new Dialog<>();
        dialog.setTitle(title);
        dialog.setResizable(true);
        dialog.getDialogPane().getButtonTypes().add(ButtonType.NEXT);

        return this.actualInputProvider.requestData(title);
    }

    @Override
    public InputProvider getNext(final Map<String, Object> lastDataSet) {
        return new CustomInputProvider(this.actualInputProvider);
    }
}
