/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.customGui.gui;

import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;

public final class CustomInputProvider
implements InputProvider {
    private final InputProvider actualInputProvider;

    public CustomInputProvider(InputProvider inputProvider) {
        this.actualInputProvider = inputProvider;
    }

    public InputProvider needString(String id, String prompt, Optional<String> defaultValue, Validator<String> ... validators) throws InputProviderException {
        return this.actualInputProvider.needString(id, prompt, defaultValue, validators);
    }

    public InputProvider fixedString(String id, String fixedValue) throws InputProviderException {
        return this.actualInputProvider.fixedString(id, fixedValue);
    }

    public InputProvider needInteger(String id, String prompt, Optional<Integer> defaultValue, Validator<Integer> ... validators) throws InputProviderException {
        return this.actualInputProvider.needInteger(id, prompt, defaultValue, validators);
    }

    public InputProvider fixedInteger(String id, Integer fixedValue) throws InputProviderException {
        return this.actualInputProvider.fixedInteger(id, fixedValue);
    }

    public InputProvider needBoolean(String id, String prompt, Optional<Boolean> defaultValue, Validator<Boolean> ... validators) throws InputProviderException {
        return this.actualInputProvider.needBoolean(id, prompt, defaultValue, validators);
    }

    public InputProvider fixedBoolean(String id, Boolean fixedValue) throws InputProviderException {
        return this.actualInputProvider.fixedBoolean(id, fixedValue);
    }

    public InputProvider needObject(String id, String prompt, Optional<Object> defaultValue, Set<? extends Object> objectSet) throws InputProviderException {
        this.actualInputProvider.needObject(id, prompt, defaultValue, objectSet);
        return this;
    }

    public InputProvider fixedObject(String id, Object fixedValue) throws InputProviderException {
        return this.actualInputProvider.fixedObject(id, fixedValue);
    }

    public Map<String, Object> requestData(String title) throws InputProviderException {
        Dialog dialog = new Dialog();
        dialog.setTitle(title);
        dialog.setResizable(true);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.NEXT);
        return this.actualInputProvider.requestData(title);
    }

    public InputProvider getNext(Map<String, Object> lastDataSet) {
        return new CustomInputProvider(this.actualInputProvider);
    }
}

