/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-demo.
 *
 * Ipspiel21-demo is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-demo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-demo. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.demo.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel21.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoState;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoStrategy;
import de.fhdw.gaming.ipspiel21.demo.moves.DemoMove;
import de.fhdw.gaming.ipspiel21.demo.moves.factory.DemoMoveFactory;

/**
 * Implements {@link DemoStrategy} by always saying "yes".
 */
public final class DemoSayYesStrategy implements DemoStrategy {

    /**
     * The factory for creating Demo moves.
     */
    private final DemoMoveFactory moveFactory;

    /**
     * Creates an {@link DemoSayYesStrategy}.
     *
     * @param moveFactory The factory for creating Demo moves.
     */
    DemoSayYesStrategy(final DemoMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<DemoMove> computeNextMove(final int gameId, final DemoPlayer player, final DemoState state) {
        return Optional.of(this.moveFactory.createYesMove());
    }

    @Override
    public String toString() {
        return DemoSayYesStrategy.class.getSimpleName();
    }
}
