/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl;

import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.AbstractDilemmaMove;
import de.fhdw.gaming.ipspiel21.evolution.EvolutionPlayerImpl;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DilemmaPlayerImpl
extends EvolutionPlayerImpl
implements DilemmaPlayer {
    private final DilemmaState gameState;
    private final String name;
    private AbstractDilemmaMove move;
    private final Map<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>> possibleOutcomes;

    DilemmaPlayerImpl(DilemmaState gameState, String name, Map<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>> possibleOutcomes) {
        this.gameState = gameState;
        this.name = Objects.requireNonNull(name, "name");
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
    }

    public String toString() {
        return String.format("DilemmaPlayer[name=%s, state=%s, outcome=%s, move=%s]", this.name, this.getState(), this.getOutcome(), this.move);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DilemmaPlayerImpl) {
            DilemmaPlayerImpl other = (DilemmaPlayerImpl)obj;
            return this.name.equals(other.name) && this.getState().equals((Object)other.getState()) && this.getMove().equals(other.getMove()) && this.getOutcome().equals(other.getOutcome());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    public PlayerState getState() {
        return this.gameState.getPlayerState(this.name);
    }

    public Optional<Double> getOutcome() {
        return this.gameState.getPlayerOutcome(this.name);
    }

    @Override
    public DilemmaPlayer deepCopy(DilemmaState newGameState) {
        return new DilemmaPlayerImpl(newGameState, this.name, this.possibleOutcomes);
    }

    @Override
    public AbstractDilemmaMove getMove() {
        return this.move;
    }

    @Override
    public void setMove(AbstractDilemmaMove move) {
        this.move = move;
    }
}

