/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-Dilemma.
 *
 * Ipspiel21-Dil is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-Dil is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-Dilemma. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaGame;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaMoveChecker;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaDefaultMoveFactory;

/**
 * Implements the Dilemma game.
 * 
 * @param <P>
 */
final class DilemmaGameImpl<P> extends DefaultGame<DilemmaPlayer, DilemmaState, DilemmaMove, DilemmaStrategy>
        implements DilemmaGame {

    /**
     * The move factory.
     */
    private final DilemmaMoveFactory moveFactory;

    /**
     * Creates a Dilemma game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    DilemmaGameImpl(final int id, final DilemmaState initialState, final Map<String, DilemmaStrategy> strategies,
            final long maxComputationTimePerMove, final DilemmaMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {

        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new DilemmaDefaultMoveFactory();
    }

    @Override
    public Optional<DilemmaMove> chooseRandomMove(final DilemmaPlayer player, final DilemmaState state) {
        // choose "no" to punish lame strategies
        return Optional.of(this.moveFactory.createNoMove());
    }

    @Override
    public String toString() {
        return String.format("DilemmaGame[id=%d, %s]", this.getId(), this.gameToString());
    }

}
