package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;

/**
 * Implements {@link DilemmaStrategy} with a nasty strategy.Spielt periodisch die Folge verraten/verraten/kooperieren.
 */
public final class DilemmaNastyStrategy implements DilemmaStrategy {

    /**
     * Factory for creating Dilemma moves.
     */
    private final DilemmaMoveFactory moveFactory;

    /**
     * Creates an {@link DilemmaNastyStrategy}.
     *
     * @param moveFactory The factory for creating Dilemma moves.
     */
    public DilemmaNastyStrategy(final DilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<DilemmaMove> computeNextMove(final int gameId, final DilemmaPlayer player,
            final DilemmaState state) throws GameException, InterruptedException {
        // Player should stay confess in the first round
        if (player.getGameHistoryCollection().numberOfPlayedGames() % 3 == 2) {
            return Optional.of(moveFactory.createYesMove());
        } else {
            return Optional.of(moveFactory.createNoMove());
        }
    }

    @Override
    public String toString() {
        return DilemmaNastyStrategy.class.getSimpleName();
    }
}
