package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.factory.DilemmaStrategyFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;

/**
 * Implements {@link DilemmaStrategyFactory} by creating a {@link DilemmaMistrustStrategy}.
 */

public class DilemmaMistrustStrategyFactory implements DilemmaStrategyFactory {

    @Override
    public final DilemmaStrategy create(final DilemmaMoveFactory moveFactory) {
        return new DilemmaMistrustStrategy(moveFactory);
    }

}
