/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.evolution;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel21.evolution.EvolutionPlayer;
import de.fhdw.gaming.ipspiel21.evolution.GameHistory;
import de.fhdw.gaming.ipspiel21.evolution.GameHistoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class MemoryObserver
implements Observer {
    public static final MemoryObserver INSTANCE = new MemoryObserver();

    public void started(Game<?, ?, ?, ?> game, State<?, ?> state) throws InterruptedException {
    }

    public void legalMoveApplied(Game<?, ?, ?, ?> game, State<?, ?> state, Player player, Move<?, ?> move) throws InterruptedException {
        ArrayList players = new ArrayList(state.getPlayers().values());
        for (Player current : players) {
            if (!(current instanceof EvolutionPlayer)) continue;
            EvolutionPlayer evPlayer = (EvolutionPlayer)current;
            List<GameHistory> historyList = evPlayer.getGameHistoryCollection().getGameHistories();
            Optional<GameHistory> history = historyList.stream().filter(p -> p.getGameId().equals(game.getId())).findFirst();
            if (history.isPresent()) {
                history.get().addMove(!current.getName().equals(player.getName()), move);
                continue;
            }
            GameHistoryImpl newHistory = new GameHistoryImpl(game.getId());
            newHistory.addMove(!current.getName().equals(player.getName()), move);
            evPlayer.getGameHistoryCollection().addGameHistory(newHistory);
        }
    }

    public void finished(Game<?, ?, ?, ?> game, State<?, ?> state) throws InterruptedException {
        ArrayList players = new ArrayList(state.getPlayers().values());
        for (Player current : players) {
            if (!(current instanceof EvolutionPlayer)) continue;
            EvolutionPlayer evPlayer = (EvolutionPlayer)current;
            List<GameHistory> historyList = evPlayer.getGameHistoryCollection().getGameHistories();
            Optional<GameHistory> history = historyList.stream().filter(p -> p.getGameId().equals(game.getId())).findFirst();
            history.get().setOutcome(false, state.getPlayerOutcome(current.getName()));
            for (Player current2 : players) {
                if (current2.getName().equals(current.getName())) continue;
                history.get().setOutcome(true, state.getPlayerOutcome(current2.getName()));
            }
        }
    }

    public void nextPlayersComputed(Game<?, ?, ?, ?> game, State<?, ?> state, Set<? extends Player> players) throws InterruptedException {
    }

    public void illegalPlayerRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player player) throws InterruptedException {
    }

    public void illegalMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player player, Optional<Move<?, ?>> move, String reason) throws InterruptedException {
    }

    public void overdueMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player player, Optional<Move<?, ?>> chosenMove) throws InterruptedException {
    }

    public void playerResigned(Game<?, ?, ?, ?> game, State<?, ?> state, Player player) throws InterruptedException {
    }

    public void playerOvertaken(Game<?, ?, ?, ?> game, State<?, ?> state, Player overtakenPlayer, Player overtakingPlayer) throws InterruptedException {
    }
}

