/**
 *
 */
package de.fhdw.gaming.ipspiel21.evolution;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;

/**
 * Implements @Observer. Handles the player memories.
 *
 */
public class MemoryObserver implements Observer {

    /**
     * MemoryObserver singleton.
     */
    public static final MemoryObserver INSTANCE = new MemoryObserver();

    @Override
    public void started(final Game<?, ?, ?, ?> game, final State<?, ?> state) throws InterruptedException {
        // nothing to do
    }

    @Override
    public void legalMoveApplied(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player,
            final Move<?, ?> move) throws InterruptedException {
        final List<Player> players = new ArrayList<>(state.getPlayers().values());
        for (final Player current : players) {
            if (current instanceof EvolutionPlayer) {
                final EvolutionPlayer evPlayer = (EvolutionPlayer) current;
                final List<GameHistory> historyList = evPlayer.getGameHistoryCollection().getGameHistories();
                final Optional<GameHistory> history = historyList.stream()
                        .filter(p -> p.getGameId().equals(game.getId())).findFirst();
                if (history.isPresent()) {
                    history.get().addMove(!current.getName().equals(player.getName()), move);
                } else {
                    final GameHistory newHistory = new GameHistoryImpl(game.getId());
                    newHistory.addMove(!current.getName().equals(player.getName()), move);
                    evPlayer.getGameHistoryCollection().addGameHistory(newHistory);
                }
            }
        }
    }

    @Override
    public void finished(final Game<?, ?, ?, ?> game, final State<?, ?> state) throws InterruptedException {
        final List<Player> players = new ArrayList<>(state.getPlayers().values());
        for (final Player current : players) {
            if (current instanceof EvolutionPlayer) {
                final EvolutionPlayer evPlayer = (EvolutionPlayer) current;
                final List<GameHistory> historyList = evPlayer.getGameHistoryCollection().getGameHistories();
                final Optional<GameHistory> history = historyList.stream()
                        .filter(p -> p.getGameId().equals(game.getId())).findFirst();
                history.get().setOutcome(false, state.getPlayerOutcome(current.getName()));
                for (final Player current2 : players) {
                    if (!current2.getName().equals(current.getName())) {
                        history.get().setOutcome(true, state.getPlayerOutcome(current2.getName()));
                    }
                }
            }
        }
    }

    @Override
    public void nextPlayersComputed(final Game<?, ?, ?, ?> game, final State<?, ?> state,
            final Set<? extends Player> players) throws InterruptedException {
        // nothing to do
    }

    @Override
    public void illegalPlayerRejected(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player)
            throws InterruptedException {
        // nothing to do
    }

    @Override
    public void illegalMoveRejected(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player,
            final Optional<Move<?, ?>> move, final String reason) throws InterruptedException {
        // nothing to do
    }

    @Override
    public void overdueMoveRejected(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player,
            final Optional<Move<?, ?>> chosenMove) throws InterruptedException {
        // nothing to do
    }

    @Override
    public void playerResigned(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player player)
            throws InterruptedException {
        // nothing to do
    }

    @Override
    public void playerOvertaken(final Game<?, ?, ?, ?> game, final State<?, ?> state, final Player overtakenPlayer,
            final Player overtakingPlayer) throws InterruptedException {
        // nothing to do
    }

}
