/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-freizeit.
 *
 * Ipspiel21-freizeit is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 *
 * Ipspiel21-freizeit is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied  * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-freizeit. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Freizeit {@link GameBuilderFactory} which allows to create a Freizeit game builder.
 */
public interface FreizeitGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on cinema/cinema.
     */
    String PARAM_PLAYER_OUTCOME_ON_CINEMA_CINEMA = "playerOutcomeOnCinemaCinema";

    /**
     * Player's outcome on cinema/soccer.
     */
    String PARAM_PLAYER_OUTCOME_ON_CINEMA_SOCCER = "playerOutcomeOnCinemaSoccer";

    /**
     * Player's outcome on soccer/cinema.
     */
    String PARAM_PLAYER_OUTCOME_ON_SOCCER_CINEMA = "playerOutcomeOnSoccerCinema";

    /**
     * Player's outcome on soccer/soccer.
     */
    String PARAM_PLAYER_OUTCOME_ON_SOCCER_SOCCER = "playerOutcomeOnSoccerSoccer";

    @Override
    FreizeitGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
