/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitGame;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitGameBuilder;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayerBuilder;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitStrategy;
import de.fhdw.gaming.ipspiel21.freizeit.domain.impl.FreizeitGameImpl;
import de.fhdw.gaming.ipspiel21.freizeit.domain.impl.FreizeitPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel21.freizeit.domain.impl.FreizeitStateImpl;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.AbstractFreizeitMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

final class FreizeitGameBuilderImpl
implements FreizeitGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<FreizeitPlayerBuilder> firstPlayer = Optional.empty();
    private Optional<FreizeitStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<FreizeitPlayerBuilder> secondPlayer = Optional.empty();
    private Optional<FreizeitStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    FreizeitGameBuilderImpl() {
    }

    @Override
    public FreizeitPlayerBuilder createPlayerBuilder() {
        return new FreizeitPlayerBuilderImpl();
    }

    @Override
    public FreizeitGameBuilder addPlayerBuilder(FreizeitPlayerBuilder playerBuilder, FreizeitStrategy strategy) throws GameException {
        Objects.requireNonNull(playerBuilder);
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(playerBuilder);
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(playerBuilder);
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public FreizeitGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public FreizeitGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public FreizeitGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Freizeit game needs two players.");
        }
        FreizeitStateImpl initialState = new FreizeitStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, FreizeitStrategy> strategies = new LinkedHashMap<String, FreizeitStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new FreizeitGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractFreizeitMove.class::isInstance, this.observerFactoryProvider);
    }
}

