/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-freizeit.
 *
 * Ipspiel21-freizeit is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 *
 * Ipspiel21-freizeit is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-freizeit. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.freizeit.moves.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitPlayer;
import de.fhdw.gaming.ipspiel21.freizeit.domain.FreizeitState;

/**
 * Says "cinema".
 */
public class FreizeitCinemaMove extends AbstractFreizeitMove {
    /**
     * The string of cinema.
     */
    private static final String CINEMA = "Saying cinema";

    @Override
    public void applyTo(final FreizeitState state, final FreizeitPlayer player) throws GameException {
        state.setAnswer(player, this);
    }

    @Override
    public String toString() {
        return FreizeitCinemaMove.CINEMA;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((FreizeitCinemaMove.CINEMA == null) ? 0 : FreizeitCinemaMove.CINEMA.hashCode());
        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

}
