package de.fhdw.gaming.ipspiel21.iterationalContest;

import java.util.EnumMap;

import de.fhdw.gaming.core.domain.PlayerState;

/**
 * Encapsulates a strategy together with its game counters.
 */
final class StrategyData {

    /**
     * The name of the strategy.
     */
    private final String name;
    /**
     * Counts the number of games for each possible outcome.
     */
    private final EnumMap<PlayerState, Integer> countersPerState;
    /**
     * Denotes the total outcome for this strategy.
     */
    private double totalOutcome;

    /**
     * Constructor. The total outcome is initially set to zero.
     *
     * @param name             The name of the strategy.
     * @param countersPerState Counts the number of games for each possible player state.
     */
    StrategyData(final String name, final EnumMap<PlayerState, Integer> countersPerState) {
        this.name = name;
        this.countersPerState = countersPerState;
        this.totalOutcome = 0.0;
    }

    /**
     * Returns the name of the strategy.
     */
    String getName() {
        return this.name;
    }

    /**
     * Returns the game counters for each possible player state.
     */
    EnumMap<PlayerState, Integer> getCounters() {
        return this.countersPerState;
    }

    /**
     * Returns the strategy's total outcome.
     */
    double getTotalOutcome() {
        return this.totalOutcome;
    }

    /**
     * Adds an outcome to the strategy's total outcome.
     *
     * @param outcomeToAdd The outcome to add.
     */
    void addOutcome(final double outcomeToAdd) {
        this.totalOutcome += outcomeToAdd;
    }
}