/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlPlayer;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlPlayerBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlState;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.SaidMove;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl.KopfzahlPlayerImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

final class KopfzahlPlayerBuilderImpl
implements KopfzahlPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<SaidMove, Map<SaidMove, Double>>> possibleOutcomes = Optional.empty();

    KopfzahlPlayerBuilderImpl() {
    }

    @Override
    public KopfzahlPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public KopfzahlPlayerBuilder changePossibleOutcomes(Map<SaidMove, Map<SaidMove, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public KopfzahlPlayer build(KopfzahlState state) throws GameException {
        return new KopfzahlPlayerImpl(state, this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<SaidMove, Map<SaidMove, Double>> checkPossibleOutcomes(Map<SaidMove, Map<SaidMove, Double>> outcomes) {
        if (!KopfzahlPlayerBuilderImpl.isOutcomeNullOrEmptyOutterMap(outcomes) && !KopfzahlPlayerBuilderImpl.isOutcomeNullOrEmptyInnerMap(outcomes.values())) {
            return outcomes;
        }
        throw new IllegalArgumentException();
    }

    private static boolean isOutcomeNullOrEmptyOutterMap(Map<SaidMove, Map<SaidMove, Double>> outcomes) {
        if (outcomes.isEmpty()) {
            throw new IllegalArgumentException("Possible outcomes are not defined for the player");
        }
        Iterator<Map<SaidMove, Double>> it = outcomes.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            throw new IllegalArgumentException("The input is not defined:" + it.next());
        }
        return false;
    }

    private static boolean isOutcomeNullOrEmptyInnerMap(Collection<Map<SaidMove, Double>> outcomes) {
        if (outcomes.isEmpty()) {
            throw new IllegalArgumentException("Possible outcomes are not defined for the player");
        }
        Iterator<Map<SaidMove, Double>> it = outcomes.iterator();
        while (it.hasNext()) {
            if (!it.next().values().isEmpty() && it.next().values() != null) continue;
            throw new IllegalArgumentException("The input is not defined:" + it.next());
        }
        return false;
    }
}

