package de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayer;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.SaidMove;

/**
 * Says "Kante".
 */
public class KanteMove extends AbstractKopfzahlkanteMove {

    /**
     * move was taken by player (said:Kante).
     */
    private final SaidMove saidMove = SaidMove.KANTE;

    @Override
    public void applyTo(final KopfzahlkanteState state, final KopfzahlkantePlayer player) throws GameException {
        state.setAnswer(player, saidMove);
    }

    @Override
    public SaidMove getSaidMove() {
        return saidMove;
    }

}
