/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.searchtrees.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.Evaluation;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.NextMoveGenerator;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.SearchTreeAlgorithms;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.impl.MoveEvaluationPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class AlphaBetaImpl<P extends Player, S extends State<P, S>, M extends Move<P, S>>
implements SearchTreeAlgorithms<P, S, M> {
    @Override
    public Optional<M> getBestMove(int depth, P currentPlayer, NextMoveGenerator<P, S, M> generator, S state, Evaluation<P, S> evaluator) throws GameException {
        Player otherPlayer = state.getPlayers().values().stream().filter(p -> !p.equals(currentPlayer)).findAny().get();
        ArrayList moveBewertungen = new ArrayList();
        Collection<M> allPossibleMoves = generator.getAllNextMoves(state, currentPlayer);
        for (Move move : allPossibleMoves) {
            State stateCopy = state.deepCopy();
            move.applyTo(stateCopy, currentPlayer);
            stateCopy.nextTurn();
            moveBewertungen.add(new MoveEvaluationPair(move, -this.alphaBetaScore(depth - 1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, otherPlayer, currentPlayer, generator, stateCopy, evaluator).doubleValue()));
        }
        return moveBewertungen.stream().max((p1, p2) -> p1.getEvaluation().compareTo(p2.getEvaluation())).map(MoveEvaluationPair::getMove);
    }

    public Double alphaBetaScore(int depth, Double alpha, Double beta, P currentPlayer, P otherPlayer, NextMoveGenerator<P, S, M> generator, S state, Evaluation<P, S> evaluator) throws GameException {
        Collection<M> allNextMoves = generator.getAllNextMoves(state, currentPlayer);
        if (depth == 0 || allNextMoves.isEmpty()) {
            return evaluator.evaluate(currentPlayer, state);
        }
        Double maxVal = alpha;
        for (Move currentMove : allNextMoves) {
            State stateCopy = state.deepCopy();
            currentMove.applyTo(stateCopy, currentPlayer);
            stateCopy.nextTurn();
            Double val = -this.alphaBetaScore(depth - 1, -beta.doubleValue(), -maxVal.doubleValue(), otherPlayer, currentPlayer, generator, stateCopy, evaluator).doubleValue();
            if (!(val > maxVal) || !((maxVal = val) >= beta)) continue;
            break;
        }
        return maxVal;
    }
}

