package de.fhdw.gaming.ipspiel21.tictactoe.strategy.best;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.fhdw.gaming.ipspiel21.searchtrees.domain.NextMoveGenerator;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToeField;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToeFieldState;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToePlayer;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToeState;
import de.fhdw.gaming.ipspiel21.tictactoe.core.moves.TicTacToeMove;
import de.fhdw.gaming.ipspiel21.tictactoe.core.moves.factory.TicTacToeMoveFactory;

/**
 *
 * generate the possible moves of current state.
 */
public class TicTacToeNextMoveGenerator implements NextMoveGenerator<TicTacToePlayer, TicTacToeState, TicTacToeMove> {

    /**
     * The factory for creating TicTacToe moves.
     */
    private final TicTacToeMoveFactory moveFactory;

    /**
     * Creates an {@link TicTacToeNextMoveGenerator}.
     *
     * @param moveFactory The factory for creating TicTacToe moves.
     */
    TicTacToeNextMoveGenerator(final TicTacToeMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Collection<TicTacToeMove> getAllNextMoves(final TicTacToeState state, final TicTacToePlayer player) {
        final List<TicTacToeField> fields = new ArrayList<>(
                state.getBoard().getFieldsBeing(TicTacToeFieldState.EMPTY).values());

        if (state.computeNextPlayers().isEmpty() || fields.isEmpty()) {
            return new ArrayList<>();
        } else {
            final Collection<TicTacToeMove> possibleMoves = new ArrayList<>();
            for (final TicTacToeField ticTacToeField : fields) {
                possibleMoves.add(
                        this.moveFactory.createPlaceMarkMove(player.isUsingCrosses(), ticTacToeField.getPosition()));
            }
            return possibleMoves;
        }
    }

}