package de.fhdw.gaming.ipspiel21.iterationalContest;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Encapsulates the results of a competition.
 */
final class CompetitionResults {

    /**
     * The results of all games played.
     */
    private final Map<Class<?>, StrategyData> gameResults;
    /**
     * Total number of games played.
     */
    private int totalNumberOfGamesPlayed;

    /**
     * Creates a {@link CompetitionResults} object.
     */
    CompetitionResults() {
        this.gameResults = new LinkedHashMap<>();
    }

    /**
     * Returns the game results.
     */
    Map<Class<?>, StrategyData> getGameResults() {
        return this.gameResults;
    }

    /**
     * Returns the total number of games played.
     */
    int getTotalNumberOfGamesPlayed() {
        return this.totalNumberOfGamesPlayed;
    }

    /**
     * Increments the total number of games played.
     */
    void incrementTotalNumberOfGamesPlayed() {
        ++this.totalNumberOfGamesPlayed;
    }
}