/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.ipspiel21.viergewinnt.strategies.group1.strategy;

import de.fhdw.gaming.ipspiel21.searchtrees.domain.Evaluation;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntBoard;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntField;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntFieldState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPosition;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import java.util.ArrayList;
import java.util.List;

public class VierGewinntEvaluation
implements Evaluation<VierGewinntPlayer, VierGewinntState> {
    public Double evaluate(VierGewinntPlayer player, VierGewinntState state) {
        double currentPLayerSum = this.evaluateHelper(this.buildWinningChances(state.getBoard(), player));
        double oppositePlayerSum = this.evaluateHelper(this.buildWinningChances(state.getBoard(), this.getOtherPlayer(player, state)));
        return currentPLayerSum - oppositePlayerSum;
    }

    private Double evaluateHelper(List<List<VierGewinntField>> winningChances) {
        Double playersum = 0.0;
        for (List<VierGewinntField> currentWinningChance : winningChances) {
            int marksInWinningChance = 0;
            for (VierGewinntField currentField : currentWinningChance) {
                if (currentField.getState().equals((Object)VierGewinntFieldState.EMPTY)) continue;
                ++marksInWinningChance;
            }
            switch (marksInWinningChance) {
                case 1: {
                    playersum = playersum + 1.0;
                    break;
                }
                case 2: {
                    playersum = playersum + 10.0;
                    break;
                }
                case 3: {
                    playersum = playersum + 50.0;
                    break;
                }
                case 4: {
                    playersum = 1000.0;
                    break;
                }
            }
        }
        return playersum;
    }

    public List<List<VierGewinntField>> buildWinningChances(VierGewinntBoard board, VierGewinntPlayer player) {
        ArrayList<List<VierGewinntField>> allAvailableWinningChances = new ArrayList<List<VierGewinntField>>();
        List<List<VierGewinntField>> rows = this.getRows(board);
        for (List<VierGewinntField> list : rows) {
            allAvailableWinningChances.addAll(this.getWinningChancesfor(list, player));
        }
        List<List<VierGewinntField>> columns = this.getColumns(board);
        for (List<VierGewinntField> list : columns) {
            allAvailableWinningChances.addAll(this.getWinningChancesfor(list, player));
        }
        List<List<VierGewinntField>> list = this.getDiagonalLtoR(board);
        for (List<VierGewinntField> list2 : list) {
            allAvailableWinningChances.addAll(this.getWinningChancesfor(list2, player));
        }
        List<List<VierGewinntField>> list3 = this.getDiagonalRtoL(board);
        for (List<VierGewinntField> currentDiagonalRtoL : list3) {
            allAvailableWinningChances.addAll(this.getWinningChancesfor(currentDiagonalRtoL, player));
        }
        return allAvailableWinningChances;
    }

    private List<List<VierGewinntField>> getWinningChancesfor(List<VierGewinntField> row, VierGewinntPlayer player) {
        VierGewinntFieldState oppositeState = player.getPlayerMark().equals((Object)VierGewinntFieldState.YELLOW) ? VierGewinntFieldState.RED : VierGewinntFieldState.YELLOW;
        ArrayList<List<VierGewinntField>> list = new ArrayList<List<VierGewinntField>>();
        for (int i = 0; i < row.size() - 3; ++i) {
            ArrayList<VierGewinntField> fields = new ArrayList<VierGewinntField>();
            if (row.get(i).getState().equals((Object)oppositeState) || row.get(i + 1).getState().equals((Object)oppositeState) || row.get(i + 2).getState().equals((Object)oppositeState) || row.get(i + 3).getState().equals((Object)oppositeState)) continue;
            fields.add(row.get(i));
            fields.add(row.get(i + 1));
            fields.add(row.get(i + 2));
            fields.add(row.get(i + 3));
            list.add(fields);
        }
        return list;
    }

    private List<List<VierGewinntField>> getColumns(VierGewinntBoard board) {
        ArrayList<List<VierGewinntField>> listOfColumns = new ArrayList<List<VierGewinntField>>();
        for (int i = 0; i < board.getRowSize(); ++i) {
            ArrayList<VierGewinntField> columnlist = new ArrayList<VierGewinntField>();
            for (int j = 0; j < board.getColumnSize(); ++j) {
                columnlist.add(board.getFieldAt(VierGewinntPosition.of((int)i, (int)j)));
            }
            listOfColumns.add(columnlist);
        }
        return listOfColumns;
    }

    private List<List<VierGewinntField>> getRows(VierGewinntBoard board) {
        ArrayList<List<VierGewinntField>> listOfRows = new ArrayList<List<VierGewinntField>>();
        for (int i = 0; i < board.getColumnSize(); ++i) {
            ArrayList<VierGewinntField> rowlist = new ArrayList<VierGewinntField>();
            for (int j = 0; j < board.getRowSize(); ++j) {
                rowlist.add(board.getFieldAt(VierGewinntPosition.of((int)j, (int)i)));
            }
            listOfRows.add(rowlist);
        }
        return listOfRows;
    }

    public List<List<VierGewinntField>> getDiagonalLtoR(VierGewinntBoard board) {
        int i;
        ArrayList<VierGewinntField> diagonalLtoR;
        int s;
        ArrayList<List<VierGewinntField>> listOfDiagonalsLtoR = new ArrayList<List<VierGewinntField>>();
        int rowSize = board.getRowSize();
        int columnSize = board.getColumnSize();
        for (s = 0; s < rowSize; ++s) {
            diagonalLtoR = new ArrayList<VierGewinntField>();
            for (i = s; i > -1; --i) {
                diagonalLtoR.add(board.getFieldAt(VierGewinntPosition.of((int)(s - i), (int)i)));
            }
            listOfDiagonalsLtoR.add(diagonalLtoR);
        }
        for (s = 1; s < columnSize; ++s) {
            diagonalLtoR = new ArrayList();
            for (i = columnSize - 1; i > s; --i) {
                diagonalLtoR.add(board.getFieldAt(VierGewinntPosition.of((int)(s + columnSize - 1 - i), (int)i)));
            }
            listOfDiagonalsLtoR.add(diagonalLtoR);
        }
        return listOfDiagonalsLtoR;
    }

    public List<List<VierGewinntField>> getDiagonalRtoL(VierGewinntBoard board) {
        int i;
        ArrayList<VierGewinntField> diagonalRtoL;
        int s;
        ArrayList<List<VierGewinntField>> listOfDiagonalsRtoL = new ArrayList<List<VierGewinntField>>();
        int rowSize = board.getRowSize();
        int columnSize = board.getColumnSize();
        for (s = 0; s < rowSize; ++s) {
            diagonalRtoL = new ArrayList<VierGewinntField>();
            for (i = s; i > -1; --i) {
                diagonalRtoL.add(board.getFieldAt(VierGewinntPosition.of((int)i, (int)(columnSize - 1 - s + i))));
            }
            listOfDiagonalsRtoL.add(diagonalRtoL);
        }
        for (s = 1; s < columnSize; ++s) {
            diagonalRtoL = new ArrayList();
            for (i = s - 1; i < rowSize; ++i) {
                diagonalRtoL.add(board.getFieldAt(VierGewinntPosition.of((int)i, (int)(i - s + 1))));
            }
            listOfDiagonalsRtoL.add(diagonalRtoL);
        }
        return listOfDiagonalsRtoL;
    }

    private VierGewinntPlayer getOtherPlayer(VierGewinntPlayer player, VierGewinntState state) {
        if (player.isUsingYellow()) {
            return state.getRedPlayer();
        }
        return state.getYellowPlayer();
    }
}

