/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.demo.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoPlayerBuilder;
import de.fhdw.gaming.ipspiel21.demo.domain.DemoState;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class DemoStateImpl
implements DemoState {
    private final DemoPlayer firstPlayer;
    private final DemoPlayer secondPlayer;
    private final Map<String, PlayerState> playerStates;
    private final Map<String, Double> playerOutcomes;
    private final Map<String, Boolean> playerAnswers;

    DemoStateImpl(DemoPlayerBuilder firstPlayerBuilder, DemoPlayerBuilder secondPlayerBuilder) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayerBuilder, "firstPlayerBuilder").build(this);
        this.secondPlayer = Objects.requireNonNull(secondPlayerBuilder, "secondPlayerBuilder").build(this);
        this.playerOutcomes = new LinkedHashMap<String, Double>();
        this.playerAnswers = new LinkedHashMap<String, Boolean>();
        this.playerStates = new LinkedHashMap<String, PlayerState>();
        this.playerStates.put(this.firstPlayer.getName(), PlayerState.PLAYING);
        this.playerStates.put(this.secondPlayer.getName(), PlayerState.PLAYING);
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    DemoStateImpl(DemoStateImpl source) {
        this.firstPlayer = source.firstPlayer.deepCopy(this);
        this.secondPlayer = source.secondPlayer.deepCopy(this);
        this.playerOutcomes = new LinkedHashMap<String, Double>(source.playerOutcomes);
        this.playerAnswers = new LinkedHashMap<String, Boolean>(source.playerAnswers);
        this.playerStates = new LinkedHashMap<String, PlayerState>();
        this.playerStates.put(this.firstPlayer.getName(), source.playerStates.get(this.firstPlayer.getName()));
        this.playerStates.put(this.secondPlayer.getName(), source.playerStates.get(this.secondPlayer.getName()));
    }

    @Override
    public DemoPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public DemoPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("DemoState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DemoStateImpl) {
            DemoStateImpl other = (DemoStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public DemoState deepCopy() {
        return new DemoStateImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, DemoPlayer> getPlayers() {
        LinkedHashMap<String, DemoPlayer> result = new LinkedHashMap<String, DemoPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public PlayerState getPlayerState(String playerName) throws IllegalArgumentException {
        PlayerState playerState = this.playerStates.get(playerName);
        if (playerState != null) {
            return playerState;
        }
        throw new IllegalArgumentException(this.buildUnknownPlayerMessage(playerName));
    }

    public void setPlayerState(String playerName, PlayerState newState) throws IllegalArgumentException {
        if (this.playerStates.containsKey(playerName)) {
            this.playerStates.put(playerName, newState);
            if (newState.equals((Object)PlayerState.PLAYING)) {
                this.playerOutcomes.remove(playerName);
            }
        } else {
            throw new IllegalArgumentException(this.buildUnknownPlayerMessage(playerName));
        }
    }

    public Optional<Double> getPlayerOutcome(String playerName) throws IllegalArgumentException {
        if (this.playerStates.containsKey(playerName)) {
            Double outcome = this.playerOutcomes.get(playerName);
            return outcome != null ? Optional.of(outcome) : DemoState.super.getPlayerOutcome(playerName);
        }
        throw new IllegalArgumentException(this.buildUnknownPlayerMessage(playerName));
    }

    public void setPlayerOutcome(String playerName, double newOutcome) throws IllegalArgumentException {
        if (this.getPlayerState(playerName).equals((Object)PlayerState.PLAYING)) {
            throw new IllegalArgumentException(String.format("Cannot set outcome for player %s.", playerName));
        }
        this.playerOutcomes.put(playerName, newOutcome);
    }

    public Set<DemoPlayer> computeNextPlayers() {
        LinkedHashSet<DemoPlayer> playersWithoutMove = new LinkedHashSet<DemoPlayer>();
        if (!this.playerAnswers.containsKey(this.firstPlayer.getName())) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (!this.playerAnswers.containsKey(this.secondPlayer.getName())) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    public void nextTurn() {
        Set<DemoPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            Boolean answerOfFirstPlayer = this.playerAnswers.get(this.firstPlayer.getName());
            Boolean answerOfSecondPlayer = this.playerAnswers.get(this.secondPlayer.getName());
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get(answerOfFirstPlayer).get(answerOfSecondPlayer);
            this.setPlayerState(this.firstPlayer.getName(), DemoStateImpl.outcomeToState(outcomeOfFirstPlayer));
            this.setPlayerOutcome(this.firstPlayer.getName(), outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get(answerOfFirstPlayer).get(answerOfSecondPlayer);
            this.setPlayerState(this.secondPlayer.getName(), DemoStateImpl.outcomeToState(outcomeOfSecondPlayer));
            this.setPlayerOutcome(this.secondPlayer.getName(), outcomeOfSecondPlayer);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : (outcome < 0.0 ? PlayerState.LOST : PlayerState.DRAW);
    }

    @Override
    public void setAnswer(DemoPlayer player, boolean answer) {
        if (this.playerStates.containsKey(player.getName())) {
            Boolean oldAnswer = this.playerAnswers.put(player.getName(), answer);
            if (oldAnswer != null) {
                throw new IllegalArgumentException(String.format("Player %s tried to change her answer.", player.getName()));
            }
        } else {
            throw new IllegalArgumentException(String.format("Unknown player %s.", player.getName()));
        }
    }

    private String buildUnknownPlayerMessage(String playerName) {
        return String.format("Unknown player %s.", playerName);
    }
}

