/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl.DilemmaPlayerImpl;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.AbstractDilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaBeSilentMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaConfessMove;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class DilemmaPlayerBuilderImpl
implements DilemmaPlayerBuilder {
    public static final Double DEFAULT_OUTCOME_SILENT_CONFESS = -10.0;
    public static final Double DEFAULT_OUTCOME_CONFESS_SILENT = 0.0;
    public static final Double DEFAULT_OUTCOME_SILENT_SILENT = -1.0;
    public static final Double DEFAULT_OUTCOME_CONFESS_CONFESS = -8.0;
    private static int defaultNameCounter = 1;
    private Optional<String> name = Optional.empty();
    private Optional<Map<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>>> possibleOutcomes = Optional.empty();
    private AbstractDilemmaMove move;

    DilemmaPlayerBuilderImpl() {
    }

    @Override
    public DilemmaPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public DilemmaPlayerBuilder changePossibleOutcomes(Map<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public DilemmaPlayer build(DilemmaState state) throws GameException {
        return new DilemmaPlayerImpl(state, this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>> checkPossibleOutcomes(Map<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>> outcomes) {
        return outcomes;
    }

    public AbstractDilemmaMove getMove() {
        return this.move;
    }

    public void setMove(AbstractDilemmaMove move) {
        this.move = move;
    }

    @Override
    public DilemmaPlayerBuilder defaultPlayerBuilder() {
        this.name = Optional.of(String.valueOf(defaultNameCounter++));
        this.possibleOutcomes = Optional.of(new HashMap<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>>(2){
            private static final long serialVersionUID = 1L;
            {
                this.put(new DilemmaBeSilentMove(), new HashMap<AbstractDilemmaMove, Double>(3){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put(new DilemmaBeSilentMove(), DEFAULT_OUTCOME_SILENT_SILENT);
                        this.put(new DilemmaConfessMove(), DEFAULT_OUTCOME_SILENT_CONFESS);
                    }
                });
                this.put(new DilemmaConfessMove(), new HashMap<AbstractDilemmaMove, Double>(3){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put(new DilemmaConfessMove(), DEFAULT_OUTCOME_CONFESS_CONFESS);
                        this.put(new DilemmaBeSilentMove(), DEFAULT_OUTCOME_CONFESS_SILENT);
                    }
                });
            }
        });
        return this;
    }
}

