package de.fhdw.gaming.ipspiel21.iterationalContest;

import de.fhdw.gaming.core.domain.GameBuilder;

/**
 * Encapsulates the parameters of a contest. A contest is a series of matches (= games) between a single set of players
 * involved, i.e. where the strategies are kept fixed.
 */
final class ContestParameters {

    /**
     * {@link GameBuilder} to use.
     */
    private final GameBuilder gameBuilder;
    /**
     * The number of games to be played.
     */
    private final int numberOfGames;

    /**
     * Creates a {@link ContestParameters} object.
     *
     * @param gameBuilder   The {@link GameBuilder} to use.
     * @param numberOfGames The number of games to be played.
     */
    ContestParameters(final GameBuilder gameBuilder, final int numberOfGames) {
        this.gameBuilder = gameBuilder;
        this.numberOfGames = numberOfGames;
    }

    /**
     * Returns the {@link GameBuilder} to use.
     */
    GameBuilder getGameBuilder() {
        return this.gameBuilder;
    }

    /**
     * Returns the number of games to be played.
     */
    int getNumberOfGames() {
        return this.numberOfGames;
    }
}