/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-Kopfzahl.
 *
 * Ipspiel21-Kopfzahl is free software: you can redistribute it and/or modify it under 
 * the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-Kopfzahl is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-Kopfzahl. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlGame;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlMoveChecker;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlPlayer;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlState;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahl.moves.KopfzahlMove;
import de.fhdw.gaming.ipspiel21.kopfzahl.moves.factory.KopfzahlMoveFactory;
import de.fhdw.gaming.ipspiel21.kopfzahl.moves.impl.KopfzahlDefaultMoveFactory;

/**
 * Implements the Kopfzahl game.
 */
final class KopfzahlGameImpl extends DefaultGame<KopfzahlPlayer, 
KopfzahlState, KopfzahlMove, KopfzahlStrategy> implements KopfzahlGame {

    /**
     * The move factory.
     */
    private final KopfzahlMoveFactory moveFactory;

    /**
     * Creates a Kopfzahl game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    KopfzahlGameImpl(final int id, final KopfzahlState initialState, final Map<String, KopfzahlStrategy> strategies,
            final long maxComputationTimePerMove, final KopfzahlMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {

        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new KopfzahlDefaultMoveFactory();
    }

    @Override
    public Optional<KopfzahlMove> chooseRandomMove(final KopfzahlPlayer player, final KopfzahlState state) {
        // choose "no" to punish lame strategies
        return Optional.of(this.moveFactory.createKopfMove());
    }

    @Override
    public String toString() {
        return String.format("KopfzahlGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}
