/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlGameBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlGameBuilderFactory;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlPlayerBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.KopfzahlStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.SaidMove;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.factory.KopfzahlDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.factory.KopfzahlStrategyFactory;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.factory.KopfzahlStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel21.kopfzahl.domain.impl.KopfzahlGameBuilderImpl;
import de.fhdw.gaming.ipspiel21.kopfzahl.moves.impl.KopfzahlDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class KopfzahlGameBuilderFactoryImpl
implements KopfzahlGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<KopfzahlStrategy> strategies;

    public KopfzahlGameBuilderFactoryImpl() {
        this(new KopfzahlDefaultStrategyFactoryProvider());
    }

    KopfzahlGameBuilderFactoryImpl(KopfzahlStrategyFactoryProvider strategyFactoryProvider) {
        KopfzahlDefaultMoveFactory moveFactory = new KopfzahlDefaultMoveFactory();
        List<KopfzahlStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<KopfzahlStrategy>();
        for (KopfzahlStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Kopfzahl";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<KopfzahlStrategy>(this.strategies);
    }

    @Override
    public KopfzahlGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            KopfzahlGameBuilderImpl gameBuilder = new KopfzahlGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayer1Data(firstPlayerInputProvider, "Player 1");
            KopfzahlPlayerBuilder firstPlayerBuilder = this.initPlayerBuilder(gameBuilder.createPlayerBuilder(), firstPlayerData);
            KopfzahlStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayerBuilder(firstPlayerBuilder, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayer2Data(secondPlayerInputProvider, "Player 2");
            KopfzahlPlayerBuilder secondPlayerBuilder = this.initPlayerBuilder(gameBuilder.createPlayerBuilder(), secondPlayerData);
            KopfzahlStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayerBuilder(secondPlayerBuilder, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Kopfzahl game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayer1Data(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnKopfKopf", "Player's outcome on Kopf/Kopf", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnKopfZahl", "Player's outcome on Kopf/Zahl", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnZahlKopf", "Player's outcome on Zahl/Kopf", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnZahlZahl", "Player's outcome on Zahl/Zahl", Optional.of(1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private Map<String, Object> requestPlayer2Data(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnKopfKopf", "Player's outcome on Kopf/Kopf", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnKopfZahl", "Player's outcome on Kopf/Zahl", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnZahlKopf", "Player's outcome on Zahl/Kopf", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnZahlZahl", "Player's outcome on Zahl/Zahl", Optional.of(-1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private KopfzahlPlayerBuilder initPlayerBuilder(KopfzahlPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<SaidMove, Map<SaidMove, Double>> possibleOutcomes = new LinkedHashMap<SaidMove, Map<SaidMove, Double>>();
        LinkedHashMap<SaidMove, Double> possibleOutcomesKopf = new LinkedHashMap<SaidMove, Double>();
        possibleOutcomesKopf.put(SaidMove.KOPF, Double.valueOf(((Integer)playerData.get("playerOutcomeOnKopfKopf")).intValue()));
        possibleOutcomesKopf.put(SaidMove.ZAHL, Double.valueOf(((Integer)playerData.get("playerOutcomeOnKopfZahl")).intValue()));
        possibleOutcomes.put(SaidMove.KOPF, possibleOutcomesKopf);
        LinkedHashMap<SaidMove, Double> possibleOutcomesZahl = new LinkedHashMap<SaidMove, Double>();
        possibleOutcomesZahl.put(SaidMove.KOPF, Double.valueOf(((Integer)playerData.get("playerOutcomeOnZahlKopf")).intValue()));
        possibleOutcomesZahl.put(SaidMove.ZAHL, Double.valueOf(((Integer)playerData.get("playerOutcomeOnZahlZahl")).intValue()));
        possibleOutcomes.put(SaidMove.ZAHL, possibleOutcomesZahl);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes);
    }

    private KopfzahlStrategy getStrategy(Map<String, Object> playerData) {
        return (KopfzahlStrategy)playerData.get("playerStrategy");
    }
}

