/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-Kopfzahlkante.
 *
 * Ipspiel21-Kopfzahlkante is free software: you can redistribute it and/or modify it under 
 * the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-Kopfzahlkante is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-Kopfzahlkante. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteGame;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteMoveChecker;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayer;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.KopfzahlkanteMove;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.factory.KopfzahlkanteMoveFactory;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.impl.KopfzahlkanteDefaultMoveFactory;

/**
 * Implements the Kopfzahlkante game.
 */
final class KopfzahlkanteGameImpl
        extends DefaultGame<KopfzahlkantePlayer, KopfzahlkanteState, KopfzahlkanteMove, KopfzahlkanteStrategy>
        implements KopfzahlkanteGame {

    /**
     * The move factory.
     */
    private final KopfzahlkanteMoveFactory moveFactory;

    /**
     * Creates a Kopfzahlkante game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in
     *                                  seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    KopfzahlkanteGameImpl(final int id, final KopfzahlkanteState initialState,
            final Map<String, KopfzahlkanteStrategy> strategies, final long maxComputationTimePerMove,
            final KopfzahlkanteMoveChecker moveChecker, final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {

        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new KopfzahlkanteDefaultMoveFactory();
    }

    @Override
    public Optional<KopfzahlkanteMove> chooseRandomMove(final KopfzahlkantePlayer player,
            final KopfzahlkanteState state) {
        // choose "Kopf" to punish lame strategies.
        return Optional.of(this.moveFactory.createKopfMove());
    }

    @Override
    public String toString() {
        return String.format("KopfzahlkanteGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}
