package de.fhdw.gaming.ipspiel21.kopfzahlkante.strategy;

import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayer;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.KopfzahlkanteMove;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.factory.KopfzahlkanteMoveFactory;

/**
 * Implements {@link KopfzahlkanteStrategy} by doing a random move.
 */
public class KopfzahlkanteRandomMoveStrategy implements KopfzahlkanteStrategy {

    /**
     * The factory for creating random moves.
     */
    private final KopfzahlkanteMoveFactory moveFactory;

    /**
     * Generate a random number to determinate the next move.
     */
    private final Random random;

    /**
     * Creates an {@link KopfzahlkanteRandomMoveStrategy}.
     *
     * @param moveFactory The factory for creating Kopfzahlkante moves.
     */
    KopfzahlkanteRandomMoveStrategy(final KopfzahlkanteMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.random = new Random();
    }

    @Override
    public Optional<KopfzahlkanteMove> computeNextMove(final int gameId, final KopfzahlkantePlayer player,
            final KopfzahlkanteState state) {
        final int randomNumber = random.nextInt(3);
        if (randomNumber == 0) {
            return Optional.of(this.moveFactory.createZahlMove());
        } else if (randomNumber == 1) {
            return Optional.of(this.moveFactory.createKopfMove());
        } else {
            return Optional.of(this.moveFactory.createKanteMove());
        }
    }

    @Override
    public String toString() {
        return KopfzahlkanteRandomMoveStrategy.class.getSimpleName();
    }

}
