/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaBeSilentMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.DilemmaConfessMove;
import de.fhdw.gaming.ipspiel21.evolution.GameHistoryCollection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class DilemmaCustomStrategy
implements DilemmaStrategy {
    private static final String IDENTIFIER_100_CONFESS = new DilemmaConfessMove().toString() + " Numberbased100";
    private static final String IDENTIFIER_50_CONFESS = new DilemmaConfessMove().toString() + " Numberbased50";
    private static final String IDENTIFIER_100_BESILENT = new DilemmaBeSilentMove().toString() + " Numberbased100";
    private static final String IDENTIFIER_50_BESILENT = new DilemmaBeSilentMove().toString() + " Numberbased50";
    private final Map<String, DilemmaMove> providedMoveData = new LinkedHashMap<String, DilemmaMove>();
    private Integer amountOfGames;
    private DilemmaMove initialMove;

    public void setProvidedMoveData(Map<String, Object> providedMoveData) {
        Set<Map.Entry<String, Object>> entrySet = providedMoveData.entrySet();
        this.providedMoveData.clear();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!IDENTIFIER_100_BESILENT.equals(entry.getKey()) && !IDENTIFIER_100_CONFESS.equals(entry.getKey()) && !IDENTIFIER_50_BESILENT.equals(entry.getKey()) && !IDENTIFIER_50_CONFESS.equals(entry.getKey())) continue;
            this.providedMoveData.put(entry.getKey(), (DilemmaMove)entry.getValue());
        }
    }

    public void setAmountOfGames(Integer amountOfGames) {
        this.amountOfGames = amountOfGames;
    }

    public void setInitialMove(DilemmaMove initialMove) {
        this.initialMove = initialMove;
    }

    public Optional<DilemmaMove> computeNextMove(int gameId, DilemmaPlayer player, DilemmaState state) throws GameException, InterruptedException {
        if (this.providedMoveData.isEmpty()) {
            return Optional.of(this.initialMove);
        }
        ArrayList<DilemmaMove> opponentMoves = new ArrayList<DilemmaMove>();
        GameHistoryCollection history = player.getGameHistoryCollection();
        int numGames = history.numberOfPlayedGames();
        for (int i = 0; i < this.amountOfGames; ++i) {
            if (i < numGames) {
                opponentMoves.add((DilemmaMove)history.getSpecificGameHistory(Integer.valueOf(i)).getOpponentMove(Integer.valueOf(0)));
                continue;
            }
            opponentMoves.add(null);
        }
        if (opponentMoves.isEmpty()) {
            return Optional.of(this.initialMove);
        }
        Integer countBeSilentMoves = 0;
        for (DilemmaMove dilemmaMove : opponentMoves) {
            if (!(dilemmaMove instanceof DilemmaBeSilentMove)) continue;
            Integer n = countBeSilentMoves;
            Integer n2 = countBeSilentMoves = Integer.valueOf(countBeSilentMoves + 1);
        }
        return this.getMoveByPercentage((double)countBeSilentMoves, Double.valueOf(opponentMoves.size()));
    }

    private Optional<DilemmaMove> getMoveByPercentage(Double countBeSilentMoves, Double amountOfOppenentMoves) {
        Double percent = countBeSilentMoves / amountOfOppenentMoves;
        if (percent == 1.0) {
            return Optional.of(this.providedMoveData.get(IDENTIFIER_100_BESILENT));
        }
        if (percent > 0.5) {
            return Optional.of(this.providedMoveData.get(IDENTIFIER_50_BESILENT));
        }
        if (percent <= 0.5 && percent > 0.0) {
            return Optional.of(this.providedMoveData.get(IDENTIFIER_50_CONFESS));
        }
        return Optional.of(this.providedMoveData.get(IDENTIFIER_100_CONFESS));
    }
}

