package de.fhdw.gaming.ipspiel21.evolution;

import java.util.List;

/**
 * A collection of GameHistory objects. Represents the memory of all games for a player.
 */
public interface GameHistoryCollection {

    /**
     * Returns the number of played Games.
     */
    Integer numberOfPlayedGames();

    /**
     * Returns the whole GameHistory collection.
     *
     */
    List<GameHistory> getGameHistories();

    /**
     * Returns the GameHistory at the provided index.
     *
     * @param index 0 = current game, 1 = last game, 2 = second last, etc.
     */
    GameHistory getSpecificGameHistory(Integer index);

    /**
     * Adds the provided GameHistory object to the first position to the GameHistoryCollection.
     *
     * @param history GameHistory object
     */
    void addGameHistory(GameHistory history);

}
