/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayer;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayerBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.SaidMove;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class KopfzahlkanteStateImpl
implements KopfzahlkanteState {
    private final Map<KopfzahlkantePlayer, SaidMove> playerMoves;
    private final Map<String, Double> playerOutcomes;
    private final Map<String, PlayerState> playerStates;
    private final KopfzahlkantePlayer firstPlayer;
    private final KopfzahlkantePlayer secondPlayer;

    KopfzahlkanteStateImpl(KopfzahlkantePlayerBuilder firstPlayerBuilder, KopfzahlkantePlayerBuilder secondPlayerBuilder) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayerBuilder, "firstPlayerBuilder").build(this);
        this.secondPlayer = Objects.requireNonNull(secondPlayerBuilder, "secondPlayerBuilder").build(this);
        this.playerOutcomes = new LinkedHashMap<String, Double>();
        this.playerStates = new LinkedHashMap<String, PlayerState>();
        this.playerMoves = new LinkedHashMap<KopfzahlkantePlayer, SaidMove>();
        this.playerStates.put(this.firstPlayer.getName(), PlayerState.PLAYING);
        this.playerStates.put(this.secondPlayer.getName(), PlayerState.PLAYING);
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    KopfzahlkanteStateImpl(KopfzahlkanteStateImpl source) {
        this.firstPlayer = source.firstPlayer.deepCopy(this);
        this.secondPlayer = source.secondPlayer.deepCopy(this);
        this.playerOutcomes = new LinkedHashMap<String, Double>(source.playerOutcomes);
        this.playerStates = new LinkedHashMap<String, PlayerState>();
        this.playerMoves = new LinkedHashMap<KopfzahlkantePlayer, SaidMove>();
    }

    @Override
    public KopfzahlkantePlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public KopfzahlkantePlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("KopfzahlkanteState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KopfzahlkanteStateImpl) {
            KopfzahlkanteStateImpl other = (KopfzahlkanteStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public KopfzahlkanteState deepCopy() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, KopfzahlkantePlayer> getPlayers() {
        LinkedHashMap<String, KopfzahlkantePlayer> result = new LinkedHashMap<String, KopfzahlkantePlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public PlayerState getPlayerState(String playerName) throws IllegalArgumentException {
        PlayerState playerState = this.playerStates.get(playerName);
        if (playerState != null) {
            return playerState;
        }
        throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
    }

    public void setPlayerState(String playerName, PlayerState newState) throws IllegalArgumentException {
        if (this.playerStates.containsKey(playerName)) {
            this.playerStates.put(playerName, newState);
            if (newState.equals((Object)PlayerState.PLAYING)) {
                this.playerOutcomes.remove(playerName);
            }
        } else {
            throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
        }
    }

    @Override
    public Optional<Double> getPlayerOutcome(String playerName) throws IllegalArgumentException {
        if (this.playerStates.containsKey(playerName)) {
            Double outcome = this.playerOutcomes.get(playerName);
            return outcome != null ? Optional.of(outcome) : KopfzahlkanteState.super.getPlayerOutcome(playerName);
        }
        throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
    }

    public void setPlayerOutcome(String playerName, double newOutcome) throws IllegalArgumentException {
        if (!this.playerStates.containsKey(playerName)) {
            throw new IllegalArgumentException(String.format("Unknown player %s was found.", playerName));
        }
        this.playerOutcomes.put(playerName, newOutcome);
    }

    public SaidMove getPlayerMove(KopfzahlkantePlayer player) {
        return this.playerMoves.get(player);
    }

    @Override
    public void setAnswer(KopfzahlkantePlayer player, SaidMove answer) {
        try {
            if (this.playerMoves.containsKey(player)) {
                throw new IllegalArgumentException(String.format("Player: %s have already given an answer.", player.getName()));
            }
            this.playerMoves.put(player, answer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Set<KopfzahlkantePlayer> computeNextPlayers() {
        LinkedHashSet<KopfzahlkantePlayer> playersWithoutAnswer = new LinkedHashSet<KopfzahlkantePlayer>();
        if (!this.playerMoves.containsKey(this.getFirstPlayer())) {
            playersWithoutAnswer.add(this.firstPlayer);
        }
        if (!this.playerMoves.containsKey(this.getSecondPlayer())) {
            playersWithoutAnswer.add(this.secondPlayer);
        }
        return playersWithoutAnswer;
    }

    public void nextTurn() {
        if (this.computeNextPlayers().isEmpty()) {
            this.generateOutcomes(this.firstPlayer, this.secondPlayer);
            this.generateOutcomes(this.secondPlayer, this.firstPlayer);
            this.generatePlayerState(this.firstPlayer);
            this.generatePlayerState(this.secondPlayer);
        }
    }

    private void generateOutcomes(KopfzahlkantePlayer playerOne, KopfzahlkantePlayer playerTwo) {
        SaidMove saidState1 = this.getPlayerMove(playerOne);
        SaidMove saidState2 = this.getPlayerMove(playerTwo);
        Double outcome = playerOne.getPossibleOutcomes().get((Object)saidState1).get((Object)saidState2);
        this.setPlayerOutcome(playerOne.getName(), outcome);
    }

    private void generatePlayerState(KopfzahlkantePlayer player) {
        if ((Double)player.getOutcome().get() > 0.0) {
            this.setPlayerState(player.getName(), PlayerState.WON);
        } else {
            this.setPlayerState(player.getName(), PlayerState.LOST);
        }
    }
}

