/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl;

import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntFieldState;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

final class VierGewinntFieldView
extends Region {
    private VierGewinntFieldState fieldState;
    private final Canvas canvas;
    private final ObjectProperty<Duration> moveDuration;

    VierGewinntFieldView(VierGewinntFieldState fieldState) {
        this.fieldState = fieldState;
        this.moveDuration = new SimpleObjectProperty((Object)Duration.millis((double)500.0));
        this.canvas = new Canvas(){

            public boolean isResizable() {
                return true;
            }

            public double prefWidth(double height) {
                return 0.0;
            }

            public double prefHeight(double width) {
                return 0.0;
            }

            public double maxWidth(double height) {
                return Double.POSITIVE_INFINITY;
            }

            public double maxHeight(double width) {
                return Double.POSITIVE_INFINITY;
            }
        };
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.canvas);
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.draw());
        this.setMinSize(50.0, 50.0);
        this.setMaxSize(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    ObjectProperty<Duration> moveDurationProperty() {
        return this.moveDuration;
    }

    void setFieldState(VierGewinntFieldState fieldState) {
        this.fieldState = fieldState;
        this.draw();
    }

    private void draw() {
        double sizeWidth = this.getWidth();
        double sizeHeight = this.getHeight();
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.setFill((Paint)Color.GREY);
        gc.fillRect(0.0, 0.0, sizeWidth, sizeHeight);
        gc.setFill((Paint)Color.WHITE);
        double margin = sizeWidth * 0.1;
        gc.fillOval(margin, margin, sizeWidth - 2.0 * margin, sizeWidth - 2.0 * margin);
        switch (this.fieldState) {
            case EMPTY: {
                break;
            }
            case YELLOW: {
                gc.setFill((Paint)Color.YELLOW);
                gc.fillOval(margin, margin, sizeWidth - 2.0 * margin, sizeWidth - 2.0 * margin);
                break;
            }
            case RED: {
                gc.setFill((Paint)Color.RED);
                gc.fillOval(margin, margin, sizeWidth - 2.0 * margin, sizeWidth - 2.0 * margin);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown Vier gewinnt field state '%s'.", this.fieldState));
            }
        }
    }
}

