package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Demo {@link GameBuilderFactory} which allows to create a KopfundZahl game builder.
 */
public interface KopfundZahlundKanteGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on Tail/Tail.
     */
    String PARAM_PLAYER_OUTCOME_ON_TAIL_TAIL = "playerOutcomeOnTailTail";

    /**
     * Player's outcome on Tail/Head.
     */
    String PARAM_PLAYER_OUTCOME_ON_TAIL_HEAD = "playerOutcomeOnTailHead";

    /**
     * Player's outcome on Head/Tail.
     */
    String PARAM_PLAYER_OUTCOME_ON_HEAD_TAIL = "playerOutcomeOnHeadTail";

    /**
     * Player's outcome on Head/Head.
     */
    String PARAM_PLAYER_OUTCOME_ON_HEAD_HEAD = "playerOutcomeOnHeadHead";
    
    /**
     * Player's outcome on Head/Edge.
     */
    String PARAM_PLAYER_OUTCOME_ON_HEAD_EDGE = "playerOutcomeOnHeadEdge";
    
    /**
     * Player's outcome on Edge/Head.
     */
    String PARAM_PLAYER_OUTCOME_ON_EDGE_HEAD = "playerOutcomeOnEdgeHead";
    
    /**
     * Player's outcome on Tail/Edge.
     */
    String PARAM_PLAYER_OUTCOME_ON_TAIL_EDGE = "playerOutcomeOnTailEdge";
    
    /**
     * Player's outcome on Edge/Tail.
     */
    String PARAM_PLAYER_OUTCOME_ON_EDGE_TAIL = "playerOutcomeOnEdgeTail";
    
    /**
     * Player's outcome on Edge/Edge.
     */
    String PARAM_PLAYER_OUTCOME_ON_EDGE_EDGE = "playerOutcomeOnEdgeEdge";
    
    @Override
    KopfundZahlundKanteGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
