package de.schereSteinPapier.domain.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Implements {@link SSPStrategyFactoryProvider} by using the {@link ServiceLoader}.
 */
public final class SSPDefaultStrategyFactoryProvider implements SSPStrategyFactoryProvider {

    @Override
    public List<SSPStrategyFactory> getStrategyFactories() {
        final ServiceLoader<SSPStrategyFactory> services = ServiceLoader.load(SSPStrategyFactory.class);
        final List<SSPStrategyFactory> list = new ArrayList<>();
        services.iterator().forEachRemaining(list::add);
        return list;
    }
}
