/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGBoard;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VGStateImpl
implements VGState {
    private final VGBoard board;
    private final VGPlayer redPlayer;
    private final VGPlayer yellowPlayer;
    private VGPlayer currentPlayer;

    public VGStateImpl(VGBoard board, VGPlayer redPlayer, VGPlayer yellowPlayer, boolean redIsNext) throws GameException {
        this.board = Objects.requireNonNull(board, "board");
        this.redPlayer = Objects.requireNonNull(redPlayer, "redPlayerBuilder");
        this.yellowPlayer = Objects.requireNonNull(yellowPlayer, "yellowPlayerBuilder");
        VGPlayer vGPlayer = this.currentPlayer = redIsNext ? this.redPlayer : this.yellowPlayer;
        if (!this.redPlayer.isUsingRedChips()) {
            throw new IllegalArgumentException(String.format("Red player %s does not use red chips.", this.redPlayer));
        }
        if (this.yellowPlayer.isUsingRedChips()) {
            throw new IllegalArgumentException(String.format("Yellow player %s does not use yellow tokens.", this.yellowPlayer));
        }
    }

    VGStateImpl(VGStateImpl source) {
        this.board = source.board.deepCopy();
        this.redPlayer = (VGPlayer)source.redPlayer.deepCopy();
        this.yellowPlayer = (VGPlayer)source.yellowPlayer.deepCopy();
        this.currentPlayer = source.isRedPlayerCurrent() ? this.redPlayer : this.yellowPlayer;
    }

    public String toString() {
        return String.format("VGState[board=%s, redPlayer=%s, yellowPlayer=%s, currentPlayer=%s]", new Object[]{this.board, this.redPlayer, this.yellowPlayer, this.currentPlayer.isUsingRedChips() ? VGFieldState.RED : VGFieldState.YELLOW});
    }

    public boolean equals(Object obj) {
        if (obj instanceof VGStateImpl) {
            VGStateImpl other = (VGStateImpl)obj;
            return this.board.equals(other.board) && this.redPlayer.equals(other.redPlayer) && this.yellowPlayer.equals(other.yellowPlayer) && this.isRedPlayerCurrent() == other.isRedPlayerCurrent();
        }
        return false;
    }

    public VGState deepCopy() {
        return new VGStateImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.board, this.redPlayer, this.yellowPlayer, this.isRedPlayerCurrent());
    }

    public Map<String, VGPlayer> getPlayers() {
        LinkedHashMap<String, VGPlayer> result = new LinkedHashMap<String, VGPlayer>();
        result.put(this.redPlayer.getName(), this.redPlayer);
        result.put(this.yellowPlayer.getName(), this.yellowPlayer);
        return result;
    }

    public Set<VGPlayer> computeNextPlayers() {
        return Collections.singleton(this.currentPlayer);
    }

    public void nextTurn() {
        ArrayList allFields = new ArrayList();
        this.getBoard().getFields().forEach(allFields::addAll);
        if (allFields.stream().noneMatch(vgField -> vgField.getState().equals((Object)VGFieldState.EMPTY))) {
            if (this.checkWinner(this.currentPlayer)) {
                this.currentPlayer.setState(PlayerState.WON);
                this.getOtherPlayer().setState(PlayerState.LOST);
            } else {
                this.gameOver();
            }
        } else if (this.checkWinner(this.currentPlayer)) {
            this.currentPlayer.setState(PlayerState.WON);
            this.getOtherPlayer().setState(PlayerState.LOST);
        }
        this.currentPlayer = this.getOtherPlayer();
    }

    public boolean checkWinner(VGPlayer player) {
        VGFieldState state = VGFieldState.YELLOW;
        if (player.isUsingRedChips()) {
            state = VGFieldState.RED;
        }
        return this.checkVertical(state);
    }

    private Boolean checkVertical(VGFieldState state) {
        for (int i = 0; i < this.board.getColumns(); ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!this.board.getFields().get(i).get(j).getState().equals((Object)state) || !this.board.getFields().get(i).get(j + 1).getState().equals((Object)state) || !this.board.getFields().get(i).get(j + 2).getState().equals((Object)state) || !this.board.getFields().get(i).get(j + 3).getState().equals((Object)state)) continue;
                return true;
            }
        }
        return this.checkHorizontal(state);
    }

    private Boolean checkHorizontal(VGFieldState state) {
        for (int i = 0; i < this.board.getRows(); ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!this.board.getFields().get(j).get(i).getState().equals((Object)state) || !this.board.getFields().get(j + 1).get(i).getState().equals((Object)state) || !this.board.getFields().get(j + 2).get(i).getState().equals((Object)state) || !this.board.getFields().get(j + 3).get(i).getState().equals((Object)state)) continue;
                return true;
            }
        }
        return this.checkDiagonalLeftToRight(state);
    }

    private Boolean checkDiagonalLeftToRight(VGFieldState state) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!this.board.getFields().get(j).get(i).getState().equals((Object)state) || !this.board.getFields().get(j + 1).get(i + 1).getState().equals((Object)state) || !this.board.getFields().get(j + 2).get(i + 2).getState().equals((Object)state) || !this.board.getFields().get(j + 3).get(i + 3).getState().equals((Object)state)) continue;
                return true;
            }
        }
        return this.checkDiagonalRightToLeft(state);
    }

    private Boolean checkDiagonalRightToLeft(VGFieldState state) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 3; j < 7; ++j) {
                if (!this.board.getFields().get(j).get(i).getState().equals((Object)state) || !this.board.getFields().get(j - 1).get(i + 1).getState().equals((Object)state) || !this.board.getFields().get(j - 2).get(i + 2).getState().equals((Object)state) || !this.board.getFields().get(j - 3).get(i + 3).getState().equals((Object)state)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public VGBoard getBoard() {
        return this.board;
    }

    @Override
    public VGPlayer getRedPlayer() {
        return this.redPlayer;
    }

    @Override
    public VGPlayer getYellowPlayer() {
        return this.yellowPlayer;
    }

    @Override
    public VGPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    private VGPlayer getOtherPlayer() {
        if (this.isRedPlayerCurrent()) {
            return this.yellowPlayer;
        }
        return this.redPlayer;
    }

    private boolean isRedPlayerCurrent() {
        return this.currentPlayer.equals(this.redPlayer);
    }

    @Override
    public void gameOver() {
        this.redPlayer.setState(PlayerState.DRAW);
        this.yellowPlayer.setState(PlayerState.DRAW);
    }
}

