package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.factory;

import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.factory.GDMoveFactory;

/**
 * Represents a factory creating Gefangenen Dilemma strategies.
 */
@FunctionalInterface
public interface GDStrategyFactory {
    /**
     * Creates a Gefangenen Dilemma strategy.
     *
     * @param moveFactory The {@link GDMoveFactory} to use.
     * @return The Gefangenen Dilemma strategy.
     */
    GDStrategy create(GDMoveFactory moveFactory);
}
