/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl;

import de.fhdw.gaming.core.domain.AbstractPlayer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteAnswerEnum;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class KopfundZahlundKantePlayerImpl
extends AbstractPlayer<KopfundZahlundKantePlayer>
implements KopfundZahlundKantePlayer {
    private final Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> possibleOutcomes;
    private Optional<KopfundZahlundKanteAnswerEnum> answer;

    public KopfundZahlundKantePlayerImpl(String name, Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> possibleOutcomes) {
        super(name);
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
        this.answer = Optional.empty();
    }

    KopfundZahlundKantePlayerImpl(KopfundZahlundKantePlayer source) {
        super((Player)source);
        this.possibleOutcomes = source.getPossibleOutcomes();
        this.answer = source.getAnswer();
    }

    public String toString() {
        return String.format("KopfundZahlundKantePlayer[name=%s, state=%s, outcome=%s, answer=%s]", this.getName(), this.getState(), this.getOutcome(), this.answer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KopfundZahlundKantePlayerImpl) {
            KopfundZahlundKantePlayerImpl other = (KopfundZahlundKantePlayerImpl)obj;
            return super.equals(obj) && this.answer.equals(other.answer);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Map<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public Optional<KopfundZahlundKanteAnswerEnum> getAnswer() {
        return this.answer;
    }

    @Override
    public void setAnswer(KopfundZahlundKanteAnswerEnum newAnswer) {
        if (this.answer.isPresent()) {
            throw new IllegalStateException(String.format("Player %s tried to change her answer.", this.getName()));
        }
        this.answer = Optional.of(newAnswer);
    }

    public KopfundZahlundKantePlayer deepCopy() {
        return new KopfundZahlundKantePlayerImpl(this);
    }
}

