package de.fhdw.gaming.ipspiel22.kopfundzahl.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlState;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.KopfundZahlMove;
import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.factory.KopfundZahlMoveFactory;

/**
 * Implements {@link KopfundZahlStrategy} by always saying "Head".
 */
public final class KopfundZahlKopfStrategy implements KopfundZahlStrategy {

    /**
     * The factory for creating KopfundZahl moves.
     */
    private final KopfundZahlMoveFactory moveFactory;

    /**
     * Creates an {@link KopfundZahlKopfStrategy}.
     *
     * @param moveFactory The factory for creating KopfundZahl moves.
     */
    public KopfundZahlKopfStrategy(final KopfundZahlMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<KopfundZahlMove> computeNextMove(final int gameId, final KopfundZahlPlayer player,
            final KopfundZahlState state) {
        return Optional.of(this.moveFactory.createHeadMove());
    }

    @Override
    public String toString() {
        return KopfundZahlKopfStrategy.class.getSimpleName();
    }
}
