/*
 * Decompiled with CFR 0.152.
 */
package de.schereSteinPapier.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.schereSteinPapier.domain.SSPGame;
import de.schereSteinPapier.domain.SSPGameBuilder;
import de.schereSteinPapier.domain.SSPPlayer;
import de.schereSteinPapier.domain.SSPPlayerBuilder;
import de.schereSteinPapier.domain.SSPStrategy;
import de.schereSteinPapier.domain.impl.SSPGameImpl;
import de.schereSteinPapier.domain.impl.SSPPlayerBuilderImpl;
import de.schereSteinPapier.domain.impl.SSPStateImpl;
import de.schereSteinPapier.moves.impl.AbstractSSPMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

final class SSPGameBuilderImpl
implements SSPGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<SSPPlayer> firstPlayer = Optional.empty();
    private Optional<SSPStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<SSPPlayer> secondPlayer = Optional.empty();
    private Optional<SSPStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    SSPGameBuilderImpl() {
    }

    @Override
    public SSPPlayerBuilder createPlayerBuilder() {
        return new SSPPlayerBuilderImpl();
    }

    @Override
    public SSPGameBuilder addPlayer(SSPPlayer player, SSPStrategy strategy) throws GameException {
        Objects.requireNonNull(player);
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(player);
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(player);
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public SSPGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public SSPGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public SSPGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A SSP game needs two players.");
        }
        SSPStateImpl initialState = new SSPStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, SSPStrategy> strategies = new LinkedHashMap<String, SSPStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new SSPGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractSSPMove.class::isInstance, this.observerFactoryProvider);
    }

    public ObserverFactoryProvider getObserverFactoryProvider() {
        return this.observerFactoryProvider;
    }

    public int getMaxComputationTimePerMove() {
        return this.maxComputationTimePerMove;
    }
}

