/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteGame;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteGameBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayerBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl.KopfundZahlundKanteGameImpl;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl.KopfundZahlundKantePlayerBuilderImpl;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl.KopfundZahlundKanteStateImpl;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.impl.AbstractKopfundZahlundKanteMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

public final class KopfundZahlundKanteGameBuilderImpl
implements KopfundZahlundKanteGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<KopfundZahlundKantePlayer> firstPlayer = Optional.empty();
    private Optional<KopfundZahlundKanteStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<KopfundZahlundKantePlayer> secondPlayer = Optional.empty();
    private Optional<KopfundZahlundKanteStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    @Override
    public KopfundZahlundKantePlayerBuilder createPlayerBuilder() {
        return new KopfundZahlundKantePlayerBuilderImpl();
    }

    @Override
    public KopfundZahlundKanteGameBuilder addPlayer(KopfundZahlundKantePlayer player, KopfundZahlundKanteStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public GameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public KopfundZahlundKanteGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public KopfundZahlundKanteGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Head and Tail game needs two players.");
        }
        KopfundZahlundKanteStateImpl initialState = new KopfundZahlundKanteStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, KopfundZahlundKanteStrategy> strategies = new LinkedHashMap<String, KopfundZahlundKanteStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new KopfundZahlundKanteGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractKopfundZahlundKanteMove.class::isInstance, this.observerFactoryProvider);
    }
}

