package de.fhdw.gaming.ipspiel22.VGStrategyEins.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel22.searchtree.domain.MinMaxGame;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGBoard;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGField;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG1ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG2ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG3ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG4ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG5ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG6ColumnMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VG7ColumnMove;

/**
 * Bewertungsfunktion.
 * 
 * @author DonPablo
 *
 */
public class Bewertung implements MinMaxGame<VGPlayer, VGState, VGMove> {

    /**
     * Spieler.
     */
    private final VGPlayer player;

    /**
     * Spielstatus.
     */
    private VGState state;

    /**
     * mf.
     */
    private final VGMoveFactory movesFactory;

    /**
     * First column move.
     */
    private final VGMove firstColumn;

    /**
     * Second column move.
     */
    private final VGMove secondColumn;

    /**
     * Third column move.
     */
    private final VGMove thirdColumn;

    /**
     * Fourth column move.
     */
    private final VGMove fourthColumn;

    /**
     * Fifth column move.
     */
    private final VGMove fifthColumn;

    /**
     * Sixth column move.
     */
    private final VGMove sixthColumn;

    /**
     * Seventh column move.
     */
    private final VGMove seventhColumn;

    /**
     * Represents the states which are common in the minMaxAlgorithm.
     */
    private final List<VGState> states = new ArrayList<>();
    
   
    /**
     * Bewertungsfunktion konstruktor.
     * 
     * @param player
     * @param state
     * @param movesFactory
     */
    public Bewertung(final VGPlayer player, final VGState state, final VGMoveFactory movesFactory) {
        this.player = player;
        this.state = state;
        this.movesFactory = movesFactory;
        this.firstColumn = movesFactory.createFirstColumnMove();
        this.secondColumn = movesFactory.createSecondColumnMove();
        this.thirdColumn = movesFactory.createThirdColumnMove();
        this.fourthColumn = movesFactory.createFourthColumnMove();
        this.fifthColumn = movesFactory.createFifthColumnMove();
        this.sixthColumn = movesFactory.createSixthColumnMove();
        this.seventhColumn = movesFactory.createSeventhColumnMove();
    }

    @Override
    public double evaluateStateful() {
        final VGPlayer currentPlayer = state.getCurrentPlayer();

        final VGBoard board = state.getBoard();

        final List<List<? extends VGField>> fields = board.getFields();

        // Die ermittelten Felder
        final List<VGField> fieldWithRed = new ArrayList<>();
        final List<VGField> fieldWithYellow = new ArrayList<>();

        /**
         * for-schleife zum evaluieren der besetzten Felder
         */
        for (final List<? extends VGField> i : fields) {
            for (final VGField m : i) {
                if (m.getState() == VGFieldState.RED) {
                    fieldWithRed.add(m);
                } else if (m.getState() == VGFieldState.YELLOW) {
                    fieldWithYellow.add(m);
                }
            }
        }   
        
        final int redPlayerScore = calcPlayerPoints(fieldWithRed);
        final int yellowPlayerScore = calcPlayerPoints(fieldWithRed);

        if (currentPlayer.isUsingRedChips()) {
            return redPlayerScore; // - yellowPlayerScore;
        } else {
            return yellowPlayerScore; // - redPlayerScore;
        }
    }
    
    /**
     * Calculate Player points.
     * @param positions position with a Token.
     * @return
     */
    private int calcPlayerPoints(final List<VGField> positions) {
        int score = 0; 
        for (final VGField vgField : positions) {
            score += checkIfPositionWorth13(vgField);
        }
        return score;
    }
    
    /**
     * Check if the given position is worth 13 points.
     * @param vgField the position to check.
     * @return score.
     */
    private int checkIfPositionWorth13(final VGField vgField) {
        final List<VGPosition> punkteDreizehn = new ArrayList<>();
        punkteDreizehn.add(new VGPosition(3, 2));
        punkteDreizehn.add(new VGPosition(3, 3));
        if (punkteDreizehn.contains(vgField.getPosition())) {
            return 13;
        } else {
            return checkIfPositionWorth11(vgField);
        }
    }
    
    /**
     * Check if the given position is worth 11 points.
     * @param vgField the position to check.
     * @return score.
     */
    private int checkIfPositionWorth11(final VGField vgField) {
        final List<VGPosition> punkteElf = new ArrayList<>();
        punkteElf.add(new VGPosition(2, 3));
        punkteElf.add(new VGPosition(2, 2));
        punkteElf.add(new VGPosition(4, 2));
        punkteElf.add(new VGPosition(4, 3));
        
        if (punkteElf.contains(vgField.getPosition())) {
            return 11;
        } else {
            return checkIfPositionWorth8(vgField);
        }
    }
    
    /**
     * Check if the given position is worth 8 points.
     * @param vgField the position to check.
     * @return score.
     */
    private int checkIfPositionWorth8(final VGField vgField) {
        final List<VGPosition> punkteAcht = new ArrayList<>();
        punkteAcht.add(new VGPosition(3, 4));
        punkteAcht.add(new VGPosition(3, 1));
        
        if (punkteAcht.contains(vgField.getPosition())) {
            return 8;
        } else {
            return checkIfPositionWorth7(vgField);
        }  
    }
    
    /**
     * Check if the given position is worth 7 points.
     * @param vgField the position to check.
     * @return score.
     */
    private int checkIfPositionWorth7(final VGField vgField) {
        final List<VGPosition> punkteSieben = new ArrayList<>();
        punkteSieben.add(new VGPosition(1, 2));
        punkteSieben.add(new VGPosition(1, 3));
        punkteSieben.add(new VGPosition(2, 1));
        punkteSieben.add(new VGPosition(2, 4));
        punkteSieben.add(new VGPosition(3, 5));
        punkteSieben.add(new VGPosition(3, 0));
        punkteSieben.add(new VGPosition(4, 4));
        punkteSieben.add(new VGPosition(4, 1));
        punkteSieben.add(new VGPosition(5, 3));
        punkteSieben.add(new VGPosition(5, 2));
        
        if (punkteSieben.contains(vgField.getPosition())) {
            return 7;
        } else {
            return checkIfPositionWorth6(vgField);
        } 
    }
    
    /**
     * Check if the given position is worth 6 points.
     * @param vgField the position to check.
     * @return score.
     */
    private int checkIfPositionWorth6(final VGField vgField) {
        final List<VGPosition> punkteSechs = new ArrayList<>();
        punkteSechs.add(new VGPosition(1, 1));
        punkteSechs.add(new VGPosition(1, 4));
        punkteSechs.add(new VGPosition(5, 1));
        punkteSechs.add(new VGPosition(5, 4));
        
        if (punkteSechs.contains(vgField.getPosition())) {
            return 6;
        } else {
            return checkIfPositionWorth5(vgField);
        }  
    }
    
    /**
     * Check if the given position is worth 5 points.
     * @param vgField the position to check.
     * @return score.
     */
    private int checkIfPositionWorth5(final VGField vgField) {
        final List<VGPosition> punkteFuenf = new ArrayList<>();
        punkteFuenf.add(new VGPosition(0, 3));
        punkteFuenf.add(new VGPosition(0, 2));
        punkteFuenf.add(new VGPosition(2, 0));
        punkteFuenf.add(new VGPosition(2, 5));
        punkteFuenf.add(new VGPosition(4, 0));
        punkteFuenf.add(new VGPosition(4, 5));
        punkteFuenf.add(new VGPosition(6, 2));
        punkteFuenf.add(new VGPosition(6, 3));
        
        if (punkteFuenf.contains(vgField.getPosition())) {
            return 5;
        } else {
            return checkIfPositionWorth4(vgField);
        }  
    }
    
    /**
     * Check if the given position is worth 4 points.
     * @param vgField the position to check.
     * @return score.
     */
    private int checkIfPositionWorth4(final VGField vgField) {
        final List<VGPosition> punkteVier = new ArrayList<>();
        punkteVier.add(new VGPosition(0, 1));
        punkteVier.add(new VGPosition(0, 4));
        punkteVier.add(new VGPosition(1, 0));
        punkteVier.add(new VGPosition(1, 5));
        punkteVier.add(new VGPosition(5, 5));
        punkteVier.add(new VGPosition(5, 0));
        punkteVier.add(new VGPosition(6, 4));
        punkteVier.add(new VGPosition(6, 1));
        
        if (punkteVier.contains(vgField.getPosition())) {
            return 4;
        } else {
            return checkIfPositionWorth3(vgField);
        }  
    }
    
    /**
     * Check if the given position is worth 3 points else return null.
     * @param vgField the position to check.
     * @return score.
     */
    private int checkIfPositionWorth3(final VGField vgField) {
        final List<VGPosition> punkteDrei = new ArrayList<>();
        punkteDrei.add(new VGPosition(0, 0));
        punkteDrei.add(new VGPosition(0, 5));
        punkteDrei.add(new VGPosition(6, 0));
        punkteDrei.add(new VGPosition(6, 5));
        
        if (punkteDrei.contains(vgField.getPosition())) {
            return 3;
        } else {
            return 0;
        }  
    }


    @Override
    public boolean isGameOver() {
        return player.getState() != PlayerState.PLAYING;
    }

    @Override
    public List<VGMove> getPossibleMoves() {
        final List<VGMove> possibleMoves = new ArrayList<>();
        
        if (Objects.nonNull(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FIRSTCOLUMN))) {
            possibleMoves.add(new VG1ColumnMove());
        }
        if (Objects.nonNull(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SECONDCOLUMN))) {
            possibleMoves.add(new VG2ColumnMove());
        }
        if (Objects.nonNull(state.getBoard().getNextFieldInColumn(VGAnswerEnum.THIRDCOLUMN))) {
            possibleMoves.add(new VG3ColumnMove());
        }
        if (Objects.nonNull(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FOURTHCOLUMN))) {
            possibleMoves.add(new VG4ColumnMove());
        }
        if (Objects.nonNull(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FITFHCOLUMN))) {
            possibleMoves.add(new VG5ColumnMove());
        }
        if (Objects.nonNull(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SIXTHCOLUMN))) {
            possibleMoves.add(new VG6ColumnMove());
        }
        if (Objects.nonNull(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SEVENTHCOLUMN))) {
            possibleMoves.add(new VG7ColumnMove());
        }
        
        Collections.shuffle(possibleMoves);
        return possibleMoves;
    }

    @Override
    public void commitMove(final VGMove move) throws GameException {
        states.add(this.state);
//        move.applyTo(this.state, this.player);

        if (move.equals(firstColumn)) {
//            movesFactory.createFirstColumnMove();
            this.movesFactory.createTokenMove(player.isUsingRedChips(),
                    state.getBoard().getNextFieldInColumn(VGAnswerEnum.FIRSTCOLUMN).getPosition());

        } else if (move.equals(secondColumn)) {
//            movesFactory.createSecondColumnMove();
            this.movesFactory.createTokenMove(player.isUsingRedChips(),
                    state.getBoard().getNextFieldInColumn(VGAnswerEnum.SECONDCOLUMN).getPosition());

        } else if (move.equals(thirdColumn)) {
//            movesFactory.createThirdColumnMove();
            this.movesFactory.createTokenMove(player.isUsingRedChips(),
                    state.getBoard().getNextFieldInColumn(VGAnswerEnum.THIRDCOLUMN).getPosition());

        } else if (move.equals(fourthColumn)) {
//            movesFactory.createFourthColumnMove();
            this.movesFactory.createTokenMove(player.isUsingRedChips(),
                    state.getBoard().getNextFieldInColumn(VGAnswerEnum.FOURTHCOLUMN).getPosition());

        } else if (move.equals(fifthColumn)) {
//            movesFactory.createFifthColumnMove();
            this.movesFactory.createTokenMove(player.isUsingRedChips(),
                    state.getBoard().getNextFieldInColumn(VGAnswerEnum.FITFHCOLUMN).getPosition());

        } else if (move.equals(sixthColumn)) {
//            movesFactory.createSixthColumnMove();
            this.movesFactory.createTokenMove(player.isUsingRedChips(),
                    state.getBoard().getNextFieldInColumn(VGAnswerEnum.SIXTHCOLUMN).getPosition());

        } else if (move.equals(seventhColumn)) {
//            movesFactory.createSeventhColumnMove();
            this.movesFactory.createTokenMove(player.isUsingRedChips(),
                    state.getBoard().getNextFieldInColumn(VGAnswerEnum.SEVENTHCOLUMN).getPosition());

        }

    }

    @Override
    public void rollbackMove(final VGMove move) {
        state = states.get(0);
    }
}
