/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlState;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class KopfundZahlStateImpl
implements KopfundZahlState {
    private final KopfundZahlPlayer firstPlayer;
    private final KopfundZahlPlayer secondPlayer;

    public KopfundZahlStateImpl(KopfundZahlPlayer firstPlayer, KopfundZahlPlayer secondPlayer) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayer, "firstPlayer");
        this.secondPlayer = Objects.requireNonNull(secondPlayer, "secondPlayer");
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    KopfundZahlStateImpl(KopfundZahlStateImpl source) {
        this.firstPlayer = (KopfundZahlPlayer)source.firstPlayer.deepCopy();
        this.secondPlayer = (KopfundZahlPlayer)source.secondPlayer.deepCopy();
    }

    @Override
    public KopfundZahlPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public KopfundZahlPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("KopfundZahlState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KopfundZahlStateImpl) {
            KopfundZahlStateImpl other = (KopfundZahlStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public KopfundZahlState deepCopy() {
        return new KopfundZahlStateImpl(this);
    }

    public Map<String, KopfundZahlPlayer> getPlayers() {
        LinkedHashMap<String, KopfundZahlPlayer> result = new LinkedHashMap<String, KopfundZahlPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public Set<KopfundZahlPlayer> computeNextPlayers() {
        LinkedHashSet<KopfundZahlPlayer> playersWithoutMove = new LinkedHashSet<KopfundZahlPlayer>();
        if (this.firstPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (this.secondPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    public void nextTurn() {
        Set<KopfundZahlPlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            Boolean answerOfFirstPlayer = this.firstPlayer.getAnswer().orElseThrow();
            Boolean answerOfSecondPlayer = this.secondPlayer.getAnswer().orElseThrow();
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get(answerOfFirstPlayer).get(answerOfSecondPlayer);
            this.firstPlayer.setState(KopfundZahlStateImpl.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get(answerOfFirstPlayer).get(answerOfSecondPlayer);
            this.secondPlayer.setState(KopfundZahlStateImpl.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : PlayerState.LOST;
    }
}

