package de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlGame;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlMoveChecker;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlState;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.KopfundZahlMove;
import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.factory.KopfundZahlMoveFactory;
import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.impl.DefaultKopfundZahlMoveFactory;

/**
 * Implements a KopfundZahl game.
 */
public final class KopfundZahlGameImpl extends DefaultGame<KopfundZahlPlayer, KopfundZahlState, KopfundZahlMove,
        KopfundZahlStrategy> implements KopfundZahlGame {

    /**
     * The move Factory.
     */
    private final KopfundZahlMoveFactory moveFactory;

    /**
     * Creates a KopfundZahl game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The maximum computation time per move in seconds.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    KopfundZahlGameImpl(final int id, final KopfundZahlState initialState, final Map<String,
            KopfundZahlStrategy> strategies,
            final long maxComputationTimePerMove, final KopfundZahlMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {
        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new DefaultKopfundZahlMoveFactory();
    }

    @Override
    public Optional<KopfundZahlMove> chooseRandomMove(final KopfundZahlPlayer player, final KopfundZahlState state) {
        return Optional.of(this.moveFactory.createTailMove());
    }

    @Override
    public String toString() {
        return String.format("KopfundZahlGame[id=%d, %s]", this.getId(), this.gameToString());
    }

}
