package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.factory;

import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.factory.KopfundZahlundKanteMoveFactory;

/**
 * Represents a factory creating strategies for head and tail.
 */
@FunctionalInterface
public interface KopfundZahlStrategyFactory {

    /**
     * Creates a KopfundZahl strategy.
     *
     * @param moveFactory The {@link KopfundZahlundKanteMoveFactory} to use.
     * @return The KopfundZahl strategy.
     */
    KopfundZahlundKanteStrategy create(KopfundZahlundKanteMoveFactory moveFactory);
}
