/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteAnswerEnum;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteGameBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteGameBuilderFactory;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayerBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.factory.KopfundZahlDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.factory.KopfundZahlStrategyFactory;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl.KopfundZahlundKanteGameBuilderImpl;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.impl.DefaultKopfundZahlundKanteMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class KopfundZahlundKanteGameBuilderFactoryImpl
implements KopfundZahlundKanteGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<KopfundZahlundKanteStrategy> strategies;

    public KopfundZahlundKanteGameBuilderFactoryImpl() {
        this(new KopfundZahlDefaultStrategyFactoryProvider());
    }

    KopfundZahlundKanteGameBuilderFactoryImpl(KopfundZahlDefaultStrategyFactoryProvider strategyFactoryProvider) {
        DefaultKopfundZahlundKanteMoveFactory moveFactory = new DefaultKopfundZahlundKanteMoveFactory();
        List<KopfundZahlStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<KopfundZahlundKanteStrategy>();
        for (KopfundZahlStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "KopfundZahlundKante";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<KopfundZahlundKanteStrategy>(this.strategies);
    }

    @Override
    public KopfundZahlundKanteGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            KopfundZahlundKanteGameBuilderImpl gameBuilder = new KopfundZahlundKanteGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            KopfundZahlundKantePlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            KopfundZahlundKanteStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            KopfundZahlundKantePlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            KopfundZahlundKanteStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating KopfundZahl game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        if (title.equals("Player 1")) {
            inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnTailTail", "Player's outcome on Tail/Tail", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnTailHead", "Player's outcome on Tail/Head", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnHeadTail", "Player's outcome on Head/Tail", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnHeadHead", "Player's outcome on Head/Head", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnEdgeHead", "Player's outcome on Edge/Head", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnHeadEdge", "Player's outcome on Head/Edge", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnEdgeTail", "Player's outcome on Edge/Tail", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnTailEdge", "Player's outcome on Tail/Edge", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnEdgeEdge", "Player's outcome on Edge/Edge", Optional.of(1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        } else {
            inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnTailTail", "Player's outcome on Tail/Tail", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnTailHead", "Player's outcome on Tail/Head", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnHeadTail", "Player's outcome on Head/Tail", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnHeadHead", "Player's outcome on Head/Head", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnEdgeHead", "Player's outcome on Edge/Head", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnHeadEdge", "Player's outcome on Head/Edge", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnEdgeTail", "Player's outcome on Edge/Tail", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnTailEdge", "Player's outcome on Tail/Edge", Optional.of(1), new Validator[0]).needInteger("playerOutcomeOnEdgeEdge", "Player's outcome on Edge/Edge", Optional.of(-1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        }
        return inputProvider.requestData(title);
    }

    private KopfundZahlundKantePlayer createPlayer(KopfundZahlundKantePlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>> possibleOutcomes = new LinkedHashMap<KopfundZahlundKanteAnswerEnum, Map<KopfundZahlundKanteAnswerEnum, Double>>();
        LinkedHashMap<KopfundZahlundKanteAnswerEnum, Double> possibleOutcomesTail = new LinkedHashMap<KopfundZahlundKanteAnswerEnum, Double>();
        possibleOutcomesTail.put(KopfundZahlundKanteAnswerEnum.TAIL, Double.valueOf(((Integer)playerData.get("playerOutcomeOnTailTail")).intValue()));
        possibleOutcomesTail.put(KopfundZahlundKanteAnswerEnum.EDGE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnTailEdge")).intValue()));
        possibleOutcomesTail.put(KopfundZahlundKanteAnswerEnum.HEAD, Double.valueOf(((Integer)playerData.get("playerOutcomeOnTailHead")).intValue()));
        possibleOutcomes.put(KopfundZahlundKanteAnswerEnum.TAIL, possibleOutcomesTail);
        LinkedHashMap<KopfundZahlundKanteAnswerEnum, Double> possibleOutcomesHead = new LinkedHashMap<KopfundZahlundKanteAnswerEnum, Double>();
        possibleOutcomesHead.put(KopfundZahlundKanteAnswerEnum.TAIL, Double.valueOf(((Integer)playerData.get("playerOutcomeOnHeadTail")).intValue()));
        possibleOutcomesHead.put(KopfundZahlundKanteAnswerEnum.EDGE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnHeadEdge")).intValue()));
        possibleOutcomesHead.put(KopfundZahlundKanteAnswerEnum.HEAD, Double.valueOf(((Integer)playerData.get("playerOutcomeOnHeadHead")).intValue()));
        possibleOutcomes.put(KopfundZahlundKanteAnswerEnum.HEAD, possibleOutcomesHead);
        LinkedHashMap<KopfundZahlundKanteAnswerEnum, Double> possibleOutcomesEdge = new LinkedHashMap<KopfundZahlundKanteAnswerEnum, Double>();
        possibleOutcomesEdge.put(KopfundZahlundKanteAnswerEnum.TAIL, Double.valueOf(((Integer)playerData.get("playerOutcomeOnEdgeTail")).intValue()));
        possibleOutcomesEdge.put(KopfundZahlundKanteAnswerEnum.EDGE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnEdgeEdge")).intValue()));
        possibleOutcomesEdge.put(KopfundZahlundKanteAnswerEnum.HEAD, Double.valueOf(((Integer)playerData.get("playerOutcomeOnEdgeHead")).intValue()));
        possibleOutcomes.put(KopfundZahlundKanteAnswerEnum.EDGE, possibleOutcomesEdge);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private KopfundZahlundKanteStrategy getStrategy(Map<String, Object> playerData) {
        return (KopfundZahlundKanteStrategy)playerData.get("playerStrategy");
    }
}

