package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteState;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.KopfundZahlundKanteMove;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.factory.KopfundZahlundKanteMoveFactory;

/**
 * Implements {@link KopfundZahlundKanteStrategy} by choose random between "Head","Tail" and "Edge".
 */
public final class KopfundZahlundKanteRandomStrategy implements KopfundZahlundKanteStrategy {

    /**
     * The factory for creating KopfundZahl moves.
     */
    private final KopfundZahlundKanteMoveFactory moveFactory;
    
    /**
     * Creates an {@link KopfundZahlundKanteRandomStrategy}.
     *
     * @param moveFactory The factory for creating KopfundZahl moves.
     */
    KopfundZahlundKanteRandomStrategy(final KopfundZahlundKanteMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }
    
    @Override
    public Optional<KopfundZahlundKanteMove> computeNextMove(final int gameId, final KopfundZahlundKantePlayer player,
            final KopfundZahlundKanteState state)
            throws GameException, InterruptedException {
        final int value = (int) (Math.random() * 3);
        if (value == 1) {
            return Optional.of(this.moveFactory.createHeadMove());
        } else if (value == 2) {
            return Optional.of(this.moveFactory.createTailMove());
        } else {
            return Optional.of(this.moveFactory.createEdgeMove());
        }
    }
    
    @Override
    public String toString() {
        return KopfundZahlundKanteRandomStrategy.class.getSimpleName();
    }

}
