package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteState;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.KopfundZahlundKanteMove;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.moves.factory.KopfundZahlundKanteMoveFactory;

/**
 * Implements {@link KopfundZahlundKanteStrategy} by always saying "Edge".
 */
public final class KopfundZahlundKanteKanteStrategy implements KopfundZahlundKanteStrategy {

    /**
     * The factory for creating KopfundZahl moves.
     */
    private final KopfundZahlundKanteMoveFactory moveFactory;
    
    /**
     * Creates an {@link KopfundZahlundKanteKanteStrategy}.
     *
     * @param moveFactory The factory for creating KopfundZahl moves.
     */
    KopfundZahlundKanteKanteStrategy(final KopfundZahlundKanteMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }
    
    @Override
    public Optional<KopfundZahlundKanteMove> computeNextMove(final int gameId, final KopfundZahlundKantePlayer player,
            final KopfundZahlundKanteState state) {
        return Optional.of(this.moveFactory.createEdgeMove());
    }
    
    @Override
    public String toString() {
        return KopfundZahlundKanteKanteStrategy.class.getSimpleName();
    }

}
