package de.schereSteinPapier.domain;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Player;

/**
 * Represents a Demo player.
 */
public interface SSPPlayer extends Player<SSPPlayer> {

    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<String, Map<String, Double>> getPossibleOutcomes();

    /**
     * Returns the answer of this player.
     */
    Optional<String> getAnswer();

    /**
     * Records the answer of this player.
     *
     * @param answer The player's answer.
     */
    void setAnswer(String answer);
}
